/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.block;

import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.teacon.xkdeco.block.DisplayBlock;
import org.teacon.xkdeco.blockentity.BlockDisplayBlockEntity;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public final class BlockDisplayBlock
extends DisplayBlock {
    public BlockDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BlockDisplayBlockEntity(pPos, pState);
    }

    @Override
    public boolean canBeDestroyed(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockDisplayBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        return !(blockEntity instanceof BlockDisplayBlockEntity) || (be = (BlockDisplayBlockEntity)blockEntity).getStoredBlockState().m_60795_();
    }

    @Override
    protected InteractionResult useTop(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        Block block;
        BlockState blockState;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof BlockDisplayBlockEntity)) {
            return InteractionResult.FAIL;
        }
        BlockDisplayBlockEntity be = (BlockDisplayBlockEntity)blockEntity;
        boolean empty = be.getStoredBlockState().m_60795_();
        ItemStack held = pPlayer.m_21120_(pHand).m_41777_();
        InteractionResult result = super.useTop(pState, pLevel, pPos, pPlayer, pHand, pHit);
        if (!pLevel.f_46443_ && empty && !be.getStoredBlockState().m_60795_() && (blockState = (block = be.getStoredBlockState().m_60734_()).m_5573_(new BlockPlaceContext(pPlayer, pHand, held, pHit))) != null) {
            be.setStoredBlockState(blockState);
        }
        return result;
    }

    @Override
    protected InteractionResult useSide(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof BlockDisplayBlockEntity)) {
            return InteractionResult.FAIL;
        }
        BlockDisplayBlockEntity be = (BlockDisplayBlockEntity)blockEntity;
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (BlockDisplayBlock.checkEmptyProperties(pPlayer, be)) {
            return InteractionResult.CONSUME;
        }
        Property<?> property = Objects.requireNonNull(be.getSelectedProperty());
        be.setStoredBlockState(BlockDisplayBlock.cycleState(be.getStoredBlockState(), property, pPlayer.m_36341_()));
        BlockDisplayBlock.message(pPlayer, (Component)Component.m_237110_((String)(Items.f_42751_.m_5524_() + ".update"), (Object[])new Object[]{property.m_61708_(), BlockDisplayBlock.getValueName(be.getStoredBlockState(), property)}));
        return InteractionResult.CONSUME;
    }

    @Override
    protected void clickSide(BlockState blockState, Level level, BlockPos pos, ServerPlayer player, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof BlockDisplayBlockEntity)) {
            return;
        }
        BlockDisplayBlockEntity be = (BlockDisplayBlockEntity)blockEntity;
        if (BlockDisplayBlock.checkEmptyProperties((Player)player, be)) {
            return;
        }
        Property<?> property = Objects.requireNonNull(be.getSelectedProperty());
        Property<?> newProperty = BlockDisplayBlock.getRelative(be.getStoredBlockState().m_61147_(), property, player.m_36341_());
        be.setSelectedProperty(newProperty);
        BlockDisplayBlock.message((Player)player, (Component)Component.m_237110_((String)(Items.f_42751_.m_5524_() + ".select"), (Object[])new Object[]{newProperty.m_61708_(), BlockDisplayBlock.getValueName(be.getStoredBlockState(), newProperty)}));
    }

    private static boolean checkEmptyProperties(Player player, BlockDisplayBlockEntity be) {
        if (be.getSelectedProperty() == null) {
            MutableComponent s = be.getStoredBlockState().m_60734_().m_49954_();
            BlockDisplayBlock.message(player, (Component)Component.m_237110_((String)(Items.f_42751_.m_5524_() + ".empty"), (Object[])new Object[]{s}));
            return true;
        }
        return false;
    }

    private static <T extends Comparable<T>> BlockState cycleState(BlockState pState, Property<T> pProperty, boolean pBackwards) {
        return (BlockState)pState.m_61124_(pProperty, BlockDisplayBlock.getRelative(pProperty.m_6908_(), pState.m_61143_(pProperty), pBackwards));
    }

    private static <T> T getRelative(Iterable<T> pAllowedValues, @Nullable T pCurrentValue, boolean pBackwards) {
        return (T)(pBackwards ? Util.m_137554_(pAllowedValues, pCurrentValue) : Util.m_137466_(pAllowedValues, pCurrentValue));
    }

    private static void message(Player pPlayer, Component pMessageComponent) {
        ((ServerPlayer)pPlayer).m_240418_(pMessageComponent, true);
    }

    private static <T extends Comparable<T>> String getValueName(BlockState pState, Property<T> pProperty) {
        return pProperty.m_6940_(pState.m_61143_(pProperty));
    }
}

