/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.block;

import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.BasicBlock;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class HangingFasciaBlock
extends BasicBlock {
    public static final EnumProperty<Side> SIDE = EnumProperty.m_61587_((String)"side", Side.class);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;

    public HangingFasciaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SIDE, (Comparable)((Object)Side.NONE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{SIDE});
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        Direction.Axis axis = (Direction.Axis)pState.m_61143_(AXIS);
        if (pDirection.m_122434_() != axis) {
            return pState;
        }
        Side side = (Side)((Object)pState.m_61143_(SIDE));
        if (side != Side.NONE && pDirection.m_122421_() != (side == Side.POSITIVE ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE)) {
            return pState;
        }
        return HangingFasciaBlock.getSideAt(pState, (BlockGetter)pLevel, pPos, pDirection);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction.Axis axis = pContext.m_8125_().m_122428_().m_122434_();
        BlockState blockState = (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)axis);
        Direction preferredSide = axis.test(pContext.m_43719_()) ? pContext.m_43719_() : Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        return HangingFasciaBlock.getSideAt(blockState, (BlockGetter)pContext.m_43725_(), pContext.m_8083_(), preferredSide);
    }

    public static BlockState getSideAt(BlockState state, BlockGetter level, BlockPos pos, Direction preferredSide) {
        for (Direction side : List.of(preferredSide, preferredSide.m_122424_())) {
            BlockPos neighborPos = pos.m_121945_(side.m_122424_());
            BlockState neighbor = level.m_8055_(neighborPos);
            if (!neighbor.m_60659_(level, neighborPos, side, SupportType.RIGID)) continue;
            return (BlockState)state.m_61124_(SIDE, (Comparable)((Object)(side.m_122421_() == Direction.AxisDirection.NEGATIVE ? Side.POSITIVE : Side.NEGATIVE)));
        }
        return (BlockState)state.m_61124_(SIDE, (Comparable)((Object)Side.NONE));
    }

    public static enum Side implements StringRepresentable
    {
        POSITIVE,
        NEGATIVE,
        NONE;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

