/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.block;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.teacon.xkdeco.blockentity.MimicWallBlockEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class MimicWallBlock
extends WallBlock
implements EntityBlock {
    private static final VoxelShape NORTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_TEST = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape EAST_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    public static final String MIMIC_WALL_PREFIX = "mimic/";
    private final WallBlock wall;

    public static String toMimicId(ResourceLocation original) {
        return MIMIC_WALL_PREFIX + original.m_135827_() + "/" + original.m_135815_();
    }

    public MimicWallBlock(WallBlock wallDelegate) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)wallDelegate));
        this.wall = wallDelegate;
    }

    public WallBlock getWallDelegate() {
        return this.wall;
    }

    public Optional<Block> connectsTo(BlockState pState) {
        Block block;
        if (pState.m_204336_(BlockTags.f_13032_) && !((block = pState.m_60734_()) instanceof MimicWallBlock)) {
            return Optional.of(block);
        }
        return Optional.empty();
    }

    private WallSide m_58041_(boolean connectedTo, VoxelShape aboveShape, VoxelShape connectedToShape) {
        if (!connectedTo) {
            return WallSide.NONE;
        }
        if (Shapes.m_83157_((VoxelShape)connectedToShape, (VoxelShape)aboveShape, (BooleanOp)BooleanOp.f_82685_)) {
            return WallSide.LOW;
        }
        return WallSide.TALL;
    }

    private BlockState updateSides(BlockPos pos, VoxelShape aboveShape, BlockState blockState, LevelAccessor level) {
        Optional<Block> northWall = this.connectsTo(level.m_8055_(pos.m_122012_()));
        Optional<Block> eastWall = this.connectsTo(level.m_8055_(pos.m_122029_()));
        Optional<Block> southWall = this.connectsTo(level.m_8055_(pos.m_122019_()));
        Optional<Block> westWall = this.connectsTo(level.m_8055_(pos.m_122024_()));
        return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)f_57951_, (Comparable)this.m_58041_(northWall.isPresent(), aboveShape, NORTH_TEST))).m_61124_((Property)f_57950_, (Comparable)this.m_58041_(eastWall.isPresent(), aboveShape, EAST_TEST))).m_61124_((Property)f_57952_, (Comparable)this.m_58041_(southWall.isPresent(), aboveShape, SOUTH_TEST))).m_61124_((Property)f_57953_, (Comparable)this.m_58041_(westWall.isPresent(), aboveShape, WEST_TEST));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos pos = pContext.m_8083_();
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveBlockState = pContext.m_43725_().m_8055_(abovePos);
        VoxelShape aboveShape = aboveBlockState.m_60812_((BlockGetter)pContext.m_43725_(), abovePos).m_83263_(Direction.DOWN);
        FluidState fluidState = pContext.m_43725_().m_6425_(pos);
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)f_57954_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)this.updateSides(pos, aboveShape, blockState, (LevelAccessor)pContext.m_43725_()).m_61124_((Property)f_57949_, (Comparable)Boolean.valueOf(true));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing != Direction.DOWN) {
            BlockPos abovePos = pCurrentPos.m_7494_();
            BlockState aboveBlockState = pLevel.m_8055_(abovePos);
            VoxelShape aboveShape = aboveBlockState.m_60812_((BlockGetter)pLevel, abovePos).m_83263_(Direction.DOWN);
            BlockEntity blockEntity = pLevel.m_7702_(pCurrentPos);
            if (blockEntity instanceof MimicWallBlockEntity) {
                MimicWallBlockEntity blockEntity2 = (MimicWallBlockEntity)blockEntity;
                blockEntity2.updateBlocksFromLevel(this);
            }
            return this.updateSides(pCurrentPos, aboveShape, pState, pLevel);
        }
        return pState;
    }

    public String m_7705_() {
        return this.wall.m_7705_();
    }

    public MutableComponent m_49954_() {
        return Component.m_237110_((String)"block.xkdeco.mimic_wall", (Object[])new Object[]{this.wall.m_49954_()});
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new MimicWallBlockEntity(pPos, pState);
    }

    protected void m_142387_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState) {
        super.m_142387_(pLevel, pPlayer, pPos, this.wall.m_49966_());
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

