/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.init;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.RegisterEvent;
import org.teacon.xkdeco.XKDeco;
import org.teacon.xkdeco.block.MimicWallBlock;
import org.teacon.xkdeco.item.MimicWallItem;
import snownee.kiwi.datagen.GameObjectLookup;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class MimicWallsLoader {
    public static final String WALL_BLOCK_ENTITY = "mimic_wall";
    private static final ResourceKey<CreativeModeTab> STRUCTURE_TAB_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)XKDeco.id("structure"));

    public static void addMimicWallBlocks(RegisterEvent event) {
        List<Block> vanillaWalls = List.of(Blocks.f_50274_, Blocks.f_50275_, Blocks.f_50604_, Blocks.f_50605_, Blocks.f_50606_, Blocks.f_50607_, Blocks.f_50608_, Blocks.f_50609_, Blocks.f_220854_, Blocks.f_50610_, Blocks.f_50611_, Blocks.f_50612_, Blocks.f_50613_, Blocks.f_50614_, Blocks.f_50615_, Blocks.f_50732_, Blocks.f_50740_, Blocks.f_50711_, Blocks.f_152554_, Blocks.f_152558_, Blocks.f_152562_, Blocks.f_152592_);
        for (Block block : vanillaWalls) {
            if (!(block instanceof WallBlock)) continue;
            WallBlock wall = (WallBlock)block;
            ResourceLocation registryName = Objects.requireNonNull(BuiltInRegistries.f_256975_.m_7981_((Object)block));
            String name = MimicWallBlock.toMimicId(registryName);
            event.register(Registries.f_256747_, XKDeco.id(name), () -> new MimicWallBlock(wall));
        }
    }

    public static void addMimicWallItems(RegisterEvent event) {
        for (Holder holder : BuiltInRegistries.f_256975_.m_206115_()) {
            Block block = (Block)holder.m_203334_();
            if (!(block instanceof MimicWallBlock)) continue;
            MimicWallBlock wall = (MimicWallBlock)block;
            ResourceLocation registryName = ((ResourceKey)holder.m_203543_().orElseThrow()).m_135782_();
            event.register(Registries.f_256913_, registryName, () -> new MimicWallItem(wall, new Item.Properties()));
        }
    }

    public static void addMimicWallTags(Map<ResourceLocation, Collection<Holder<Block>>> tags) {
        ArrayList walls = Lists.newArrayList((Iterable)tags.getOrDefault(BlockTags.f_13032_.f_203868_(), List.of()));
        for (Holder holder : BuiltInRegistries.f_256975_.m_206115_()) {
            if (!(holder.m_203334_() instanceof MimicWallBlock)) continue;
            walls.add(holder);
        }
        tags.put(BlockTags.f_13032_.f_203868_(), walls);
    }

    public static void addMimicWallsToTab(BuildCreativeModeTabContentsEvent event) {
        if (STRUCTURE_TAB_KEY.equals((Object)event.getTabKey())) {
            GameObjectLookup.all((ResourceKey)Registries.f_256747_, (String)"xkdeco").forEach(block -> {
                if (block instanceof MimicWallBlock) {
                    event.m_246326_((ItemLike)block);
                }
            });
        }
    }
}

