/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.resource;

import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.teacon.xkdeco.XKDeco;
import org.teacon.xkdeco.block.MimicWallBlock;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class MimicWallResources
implements PackResources {
    private static final String BLOCK_MODEL_LOCATION = "xkdeco:block/mimic_wall";
    private static final String ITEM_MODEL_LOCATION = "xkdeco:item/mimic_wall";
    private static final String BLOCK_MODEL = "{\"variants\":{\"\":{\"model\":\"xkdeco:block/mimic_wall\"}}}";
    private static final String ITEM_MODEL = "{\"parent\":\"xkdeco:item/mimic_wall\"}";
    private static final String PACK_META = "{\"pack\":{\"description\":\"XKDeco: Mimic Walls\",\"pack_format\":8}}";
    private static final String NAME_KEY = "pack.xkdeco.mimic_walls";
    private static final String ID = "xkdeco_mimic_wall";
    private static final Pack.Info PACK_INFO = new Pack.Info((Component)Component.m_237115_((String)"pack.xkdeco.mimic_walls"), 13, 13, FeatureFlagSet.m_246902_(), true);
    private final String packId;

    public MimicWallResources(String packId) {
        this.packId = packId;
    }

    public static Pack create() {
        return Pack.m_245512_((String)ID, (Component)Component.m_237115_((String)NAME_KEY), (boolean)true, MimicWallResources::new, (Pack.Info)PACK_INFO, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10527_);
    }

    public IoSupplier<InputStream> m_8017_(String ... pFileName) {
        return null;
    }

    public IoSupplier<InputStream> m_214146_(PackType pType, ResourceLocation pLocation) {
        return null;
    }

    public void m_8031_(PackType pType, String pNamespace, String pPath, PackResources.ResourceOutput output) {
        block3: {
            block2: {
                if (!pPath.equals("blockstates")) break block2;
                for (Block block : this.walls()) {
                    ResourceLocation registryName = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block));
                    String name = MimicWallBlock.toMimicId(registryName);
                    output.accept((Object)XKDeco.id("blockstates/" + name + ".json"), () -> new ByteArrayInputStream(BLOCK_MODEL.getBytes(StandardCharsets.UTF_8)));
                }
                break block3;
            }
            if (!pPath.equals("models")) break block3;
            for (Block block : this.walls()) {
                ResourceLocation registryName = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block));
                String name = MimicWallBlock.toMimicId(registryName);
                output.accept((Object)XKDeco.id("models/item/" + name + ".json"), () -> new ByteArrayInputStream(ITEM_MODEL.getBytes(StandardCharsets.UTF_8)));
            }
        }
    }

    private Collection<Block> walls() {
        return List.of(Blocks.f_50274_, Blocks.f_50275_, Blocks.f_50604_, Blocks.f_50605_, Blocks.f_50606_, Blocks.f_50607_, Blocks.f_50608_, Blocks.f_50609_, Blocks.f_220854_, Blocks.f_50610_, Blocks.f_50611_, Blocks.f_50612_, Blocks.f_50613_, Blocks.f_50614_, Blocks.f_50615_, Blocks.f_50732_, Blocks.f_50740_, Blocks.f_50711_, Blocks.f_152554_, Blocks.f_152558_, Blocks.f_152562_, Blocks.f_152592_);
    }

    public Set<String> m_5698_(PackType pType) {
        return pType == PackType.CLIENT_RESOURCES ? Set.of("xkdeco") : Set.of();
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> pDeserializer) {
        if ("pack".equals(pDeserializer.m_7991_())) {
            return (T)pDeserializer.m_6322_(JsonParser.parseString((String)PACK_META).getAsJsonObject().getAsJsonObject("pack"));
        }
        return null;
    }

    public String m_5542_() {
        return this.packId;
    }

    public void close() {
    }

    public boolean isHidden() {
        return true;
    }
}

