/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.teacon.xkdeco.client.forge.UnbakedGeometryWrapper;
import org.teacon.xkdeco.client.model.AirDuctModel;
import org.teacon.xkdeco.client.renderer.BlockDisplayRenderer;
import org.teacon.xkdeco.client.renderer.ItemDisplayRenderer;
import org.teacon.xkdeco.client.renderer.MimicWallRenderer;
import org.teacon.xkdeco.client.renderer.XKDecoWithoutLevelRenderer;
import org.teacon.xkdeco.init.XKDecoEntityTypes;
import org.teacon.xkdeco.resource.MimicWallResources;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class ClientProxy {
    public static void setItemRenderers(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)XKDecoWithoutLevelRenderer.INSTANCE);
    }

    public static void setEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)XKDecoEntityTypes.MIMIC_WALL.getOrCreate(), MimicWallRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)XKDecoEntityTypes.ITEM_DISPLAY.getOrCreate(), ItemDisplayRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)XKDecoEntityTypes.ITEM_PROJECTOR.getOrCreate(), ItemDisplayRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)XKDecoEntityTypes.BLOCK_DISPLAY.getOrCreate(), BlockDisplayRenderer::new);
    }

    public static void setAdditionalPackFinder(AddPackFindersEvent event) {
        event.addRepositorySource(consumer -> consumer.accept(MimicWallResources.create()));
    }

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(ClientProxy::setItemRenderers);
        modEventBus.addListener(ClientProxy::setEntityRenderers);
        modEventBus.addListener(ClientProxy::setAdditionalPackFinder);
        modEventBus.addListener(event -> event.register("air_duct", (IGeometryLoader)new IGeometryLoader<UnbakedGeometryWrapper>(){

            public UnbakedGeometryWrapper read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
                ResourceLocation straight = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"straight"));
                ResourceLocation corner = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"corner"));
                ResourceLocation cover = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"cover"));
                ResourceLocation frame = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"frame"));
                return new UnbakedGeometryWrapper(new AirDuctModel(straight, corner, cover, frame));
            }
        }));
    }

    public static void registerColors(List<Pair<Block, BlockColor>> blocksToAdd, List<Pair<Item, ItemColor>> itemsToAdd) {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        if (!blocksToAdd.isEmpty()) {
            modEventBus.addListener(event -> {
                for (Pair pair : blocksToAdd) {
                    event.register((BlockColor)pair.getSecond(), new Block[]{(Block)pair.getFirst()});
                }
            });
        }
        if (!itemsToAdd.isEmpty()) {
            modEventBus.addListener(event -> {
                for (Pair pair : itemsToAdd) {
                    event.register((ItemColor)pair.getSecond(), new ItemLike[]{(ItemLike)pair.getFirst()});
                }
            });
        }
    }
}

