/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.apigame.world.ClientShipWorldCore;
import org.valkyrienskies.core.apigame.world.VSPipeline;
import org.valkyrienskies.mod.common.IShipObjectWorldClientCreator;
import org.valkyrienskies.mod.common.IShipObjectWorldClientProvider;
import org.valkyrienskies.mod.common.IShipObjectWorldServerProvider;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.util.EntityDragger;
import org.valkyrienskies.mod.mixinducks.client.MinecraftDuck;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraft
implements MinecraftDuck,
IShipObjectWorldClientProvider,
IShipObjectWorldClientCreator {
    @Unique
    private static final Logger log = LogManager.getLogger((String)"VS2 MixinMinecraft");
    @Unique
    private static long lastLog = System.currentTimeMillis();
    @Shadow
    private boolean f_91012_;
    @Shadow
    public ClientLevel f_91073_;
    @Unique
    private HitResult originalCrosshairTarget;
    @Unique
    private ClientShipWorldCore shipObjectWorld = null;

    @Shadow
    @Nullable
    public abstract IntegratedServer m_91092_();

    @Override
    public void vs$setOriginalCrosshairTarget(HitResult originalCrosshairTarget) {
        this.originalCrosshairTarget = originalCrosshairTarget;
    }

    @Override
    public HitResult vs$getOriginalCrosshairTarget() {
        return this.originalCrosshairTarget;
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;useItemOn(Lnet/minecraft/client/player/LocalPlayer;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;")}, method={"startUseItem"})
    private InteractionResult useOriginalCrosshairForBlockPlacement(MultiPlayerGameMode instance, LocalPlayer localPlayer, InteractionHand interactionHand, BlockHitResult blockHitResult, Operation<InteractionResult> useItemOn) {
        return (InteractionResult)useItemOn.call(new Object[]{instance, localPlayer, interactionHand, this.originalCrosshairTarget});
    }

    @Override
    @NotNull
    public ClientShipWorldCore getShipObjectWorld() {
        ClientShipWorldCore shipObjectWorldCopy = this.shipObjectWorld;
        if (shipObjectWorldCopy == null) {
            if (lastLog + 5000L < System.currentTimeMillis()) {
                lastLog = System.currentTimeMillis();
                log.warn("Requested getShipObjectWorld() but failed returning dummy world", (Throwable)new IllegalStateException("shipObjectWorld is null"));
            }
            return ValkyrienSkiesMod.getVsCore().getDummyShipWorldClient();
        }
        return shipObjectWorldCopy;
    }

    @Shadow
    public abstract ClientPacketListener m_91403_();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void postTick(CallbackInfo ci2) {
        if (!this.f_91012_ && this.shipObjectWorld != null && this.f_91073_ != null && this.m_91403_() != null) {
            this.shipObjectWorld.tickNetworking(this.m_91403_().m_104910_().m_129523_());
            this.shipObjectWorld.postTick();
            EntityDragger.INSTANCE.dragEntitiesWithShips(this.f_91073_.m_104735_());
        }
    }

    @Inject(method={"runTick"}, at={@At(value="TAIL")})
    public void setGamePause(boolean pauseOnly, CallbackInfo ci2) {
        VSPipeline pipeline;
        IShipObjectWorldServerProvider provider = (IShipObjectWorldServerProvider)this.m_91092_();
        if (provider != null && (pipeline = provider.getVsPipeline()) != null) {
            pipeline.setArePhysicsRunning(!this.f_91012_);
        }
    }

    @Override
    public void createShipObjectWorldClient() {
        if (this.shipObjectWorld != null) {
            throw new IllegalStateException("shipObjectWorld was not null when it should be null?");
        }
        this.shipObjectWorld = ValkyrienSkiesMod.getVsCoreClient().newShipWorldClient();
    }

    @Override
    public void deleteShipObjectWorldClient() {
        ClientShipWorldCore shipObjectWorldCopy = this.shipObjectWorld;
        if (shipObjectWorldCopy == null) {
            throw new IllegalStateException("shipObjectWorld was null when it should be not null?");
        }
        shipObjectWorldCopy.destroyWorld();
        this.shipObjectWorld = null;
    }

    @Inject(method={"clearLevel"}, at={@At(value="TAIL")})
    private void postClearLevel(CallbackInfo ci2) {
        if (this.shipObjectWorld != null) {
            this.deleteShipObjectWorldClient();
        }
    }
}

