/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch.voxel;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.physics_api.Lod1BlockRegistry;
import org.valkyrienskies.physics_api.UsingDeletedReferenceException;
import org.valkyrienskies.physics_api.VSByteBuffer;
import org.valkyrienskies.physics_api.voxel.Lod1BlockState;
import org.valkyrienskies.physics_api.voxel.Lod1LiquidBlockState;
import org.valkyrienskies.physics_api.voxel.Lod1SolidBlockState;
import org.valkyrienskies.physics_api_krunch.voxel.Lod1BlockStateSerializer;

public class KrunchLod1BlockRegistry
implements Lod1BlockRegistry {
    private static final long DELETED_ADDRESS = 0L;
    private long blockRegistryAddress;
    private final Int2ObjectMap<Lod1SolidBlockState> lod1SolidBlockStateMap = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<Lod1LiquidBlockState> lod1LiquidBlockStateMap = new Int2ObjectOpenHashMap();
    private final Lod1SolidBlockState solidAirBlockState;
    private final Lod1LiquidBlockState liquidAirBlockState;
    private final Lod1BlockState airBlockState;

    public KrunchLod1BlockRegistry(@NotNull VSByteBuffer vsByteBuffer) {
        this.blockRegistryAddress = KrunchLod1BlockRegistry.allocateNewKrunchLod1BlockRegistry();
        this.solidAirBlockState = this.getLod1SolidBlockState(0, vsByteBuffer);
        this.liquidAirBlockState = this.getLod1LiquidBlockState(0, vsByteBuffer);
        this.airBlockState = this.getLod1BlockState(0, vsByteBuffer);
        this.lod1SolidBlockStateMap.put(0, (Object)this.solidAirBlockState);
        this.lod1LiquidBlockStateMap.put(0, (Object)this.liquidAirBlockState);
    }

    public long getBlockRegistryAddress() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        return this.blockRegistryAddress;
    }

    @Override
    public void registerLod1SolidBlockState(@NotNull Lod1SolidBlockState lod1SolidBlockState, @NotNull VSByteBuffer vsByteBuffer) throws UsingDeletedReferenceException, IllegalArgumentException {
        this.ensureNotDeleted();
        vsByteBuffer.getByteBuffer().position(0);
        Lod1BlockStateSerializer.serializeLod1SolidBlockState(lod1SolidBlockState, vsByteBuffer.getByteBuffer());
        boolean success = KrunchLod1BlockRegistry.registerLod1SolidBlockState(this.blockRegistryAddress, vsByteBuffer.getDirectAddress(), vsByteBuffer.getBufferSize());
        if (!success) {
            throw new IllegalArgumentException("Already existing Lod1SolidBlockState found for Lod1SolidBlockState.lod1SolidBlockStateId");
        }
        this.lod1SolidBlockStateMap.put(lod1SolidBlockState.getLod1SolidBlockStateId(), (Object)lod1SolidBlockState);
    }

    @Override
    public void registerLod1LiquidBlockState(@NotNull Lod1LiquidBlockState lod1LiquidBlockState, @NotNull VSByteBuffer vsByteBuffer) throws UsingDeletedReferenceException, IllegalArgumentException {
        this.ensureNotDeleted();
        vsByteBuffer.getByteBuffer().position(0);
        Lod1BlockStateSerializer.serializeLod1LiquidBlockState(lod1LiquidBlockState, vsByteBuffer.getByteBuffer());
        boolean success = KrunchLod1BlockRegistry.registerLod1LiquidBlockState(this.blockRegistryAddress, vsByteBuffer.getDirectAddress(), vsByteBuffer.getBufferSize());
        if (!success) {
            throw new IllegalArgumentException("Already existing Lod1LiquidBlockState found for lod1LiquidBlockState.lod1LiquidBlockStateId");
        }
        this.lod1LiquidBlockStateMap.put(lod1LiquidBlockState.getLod1LiquidBlockStateId(), (Object)lod1LiquidBlockState);
    }

    @Override
    @NotNull
    public Lod1BlockState registerLod1BlockState(int lod1SolidBlockStateId, int lod1LiquidBlockStateId, int lod1BlockStateId) throws UsingDeletedReferenceException, IllegalArgumentException {
        this.ensureNotDeleted();
        Lod1SolidBlockState lod1SolidBlockState = (Lod1SolidBlockState)this.lod1SolidBlockStateMap.get(lod1SolidBlockStateId);
        if (lod1SolidBlockState == null) {
            throw new IllegalArgumentException("No Lod1SolidBlockState found for id " + lod1SolidBlockStateId);
        }
        Lod1LiquidBlockState lod1LiquidBlockState = (Lod1LiquidBlockState)this.lod1LiquidBlockStateMap.get(lod1LiquidBlockStateId);
        if (lod1LiquidBlockState == null) {
            throw new IllegalArgumentException("No Lod1LiquidBlockState found for id " + lod1LiquidBlockStateId);
        }
        boolean success = KrunchLod1BlockRegistry.registerLod1BlockState(this.blockRegistryAddress, lod1BlockStateId, lod1SolidBlockStateId, lod1LiquidBlockStateId);
        if (!success) {
            throw new IllegalArgumentException("Already existing Lod1BlockState found for lod1BlockStateId");
        }
        return new Lod1BlockState(lod1SolidBlockState, lod1LiquidBlockState, lod1BlockStateId);
    }

    @Override
    @Nullable
    public Lod1SolidBlockState getLod1SolidBlockState(int lod1SolidBlockStateId, @NotNull VSByteBuffer vsByteBuffer) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        boolean success = KrunchLod1BlockRegistry.getLod1SolidBlockState(this.blockRegistryAddress, lod1SolidBlockStateId, vsByteBuffer.getDirectAddress(), vsByteBuffer.getBufferSize());
        if (!success) {
            throw new IllegalArgumentException("No Lod1SolidBlockState found for lod1SolidBlockStateId");
        }
        vsByteBuffer.getByteBuffer().position(0);
        return Lod1BlockStateSerializer.deserializeLod1SolidBlockState(vsByteBuffer.getByteBuffer());
    }

    @Override
    @Nullable
    public Lod1LiquidBlockState getLod1LiquidBlockState(int lod1LiquidBlockStateId, @NotNull VSByteBuffer vsByteBuffer) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        boolean success = KrunchLod1BlockRegistry.getLod1LiquidBlockState(this.blockRegistryAddress, lod1LiquidBlockStateId, vsByteBuffer.getDirectAddress(), vsByteBuffer.getBufferSize());
        if (!success) {
            throw new IllegalArgumentException("No Lod1LiquidBlockState found for lod1LiquidBlockStateId");
        }
        vsByteBuffer.getByteBuffer().position(0);
        return Lod1BlockStateSerializer.deserializeLod1LiquidBlockState(vsByteBuffer.getByteBuffer());
    }

    @Override
    @Nullable
    public Lod1BlockState getLod1BlockState(int lod1BlockStateId, @NotNull VSByteBuffer vsByteBuffer) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        boolean success = KrunchLod1BlockRegistry.getLod1BlockState(this.blockRegistryAddress, lod1BlockStateId, vsByteBuffer.getDirectAddress(), vsByteBuffer.getBufferSize());
        if (success) {
            vsByteBuffer.getByteBuffer().position(0);
            int lod1SolidBlockStateId = vsByteBuffer.getByteBuffer().getInt();
            int lod1LiquidBlockStateId = vsByteBuffer.getByteBuffer().getInt();
            Lod1SolidBlockState lod1SolidBlockState = this.getLod1SolidBlockState(lod1SolidBlockStateId, vsByteBuffer);
            if (lod1SolidBlockState == null) {
                throw new RuntimeException("Lod1SolidBlockState with id " + lod1SolidBlockStateId + " not found!");
            }
            Lod1LiquidBlockState lod1LiquidBlockState = this.getLod1LiquidBlockState(lod1LiquidBlockStateId, vsByteBuffer);
            if (lod1LiquidBlockState == null) {
                throw new RuntimeException("Lod1LiquidBlockState with id " + lod1LiquidBlockStateId + " not found!");
            }
            return new Lod1BlockState(lod1SolidBlockState, lod1LiquidBlockState, lod1BlockStateId);
        }
        return null;
    }

    @Override
    @NotNull
    public Map<Integer, Lod1SolidBlockState> getAllLod1SolidBlockStates(@NotNull VSByteBuffer vsByteBuffer) throws UsingDeletedReferenceException {
        throw new NotImplementedError();
    }

    @Override
    @NotNull
    public Map<Integer, Lod1SolidBlockState> getAllLod1LiquidBlockStates(@NotNull VSByteBuffer vsByteBuffer) throws UsingDeletedReferenceException {
        throw new NotImplementedError();
    }

    @Override
    @NotNull
    public Map<Integer, Lod1BlockState> getAllLod1BlockStates(@NotNull VSByteBuffer vsByteBuffer) throws UsingDeletedReferenceException {
        throw new NotImplementedError();
    }

    @Override
    @NotNull
    public Lod1LiquidBlockState getLiquidAirBlockState() throws UsingDeletedReferenceException {
        return this.liquidAirBlockState;
    }

    @Override
    @NotNull
    public Lod1SolidBlockState getSolidAirBlockState() throws UsingDeletedReferenceException {
        return this.solidAirBlockState;
    }

    @Override
    @NotNull
    public Lod1BlockState getAirBlockState() throws UsingDeletedReferenceException {
        return this.airBlockState;
    }

    @Override
    public boolean isDeleted() {
        return this.blockRegistryAddress == 0L;
    }

    @Override
    public void close() {
        if (!this.isDeleted()) {
            long blockRegistryAddressLocalCopy = this.blockRegistryAddress;
            this.blockRegistryAddress = 0L;
            KrunchLod1BlockRegistry.deleteKrunchLod1BlockRegistry(blockRegistryAddressLocalCopy);
        }
    }

    protected void finalize() {
        if (!this.isDeleted()) {
            this.close();
        }
    }

    private void ensureNotDeleted() {
        if (this.isDeleted()) {
            throw new UsingDeletedReferenceException("This shape has been deleted!");
        }
    }

    private static native long allocateNewKrunchLod1BlockRegistry();

    private static native void deleteKrunchLod1BlockRegistry(long var0);

    private static native boolean registerLod1SolidBlockState(long var0, long var2, int var4);

    private static native boolean registerLod1LiquidBlockState(long var0, long var2, int var4);

    private static native boolean registerLod1BlockState(long var0, int var2, int var3, int var4);

    private static native boolean getLod1SolidBlockState(long var0, int var2, long var3, int var5);

    private static native boolean getLod1LiquidBlockState(long var0, int var2, long var3, int var5);

    private static native boolean getLod1BlockState(long var0, int var2, long var3, int var5);
}

