/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.block.EnumFramingTablePart;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockFramingTable
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<EnumFramingTablePart> PART = EnumProperty.m_61587_((String)"part", EnumFramingTablePart.class);
    protected static final VoxelShape TABLE_TOP = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape TABLE_BOTTOM_NORTH = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape TABLE_BOTTOM_SOUTH = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final VoxelShape TABLE_BOTTOM_WEST = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);
    protected static final VoxelShape TABLE_BOTTOM_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape TABLE_SHAPE_NORTH = Shapes.m_83110_((VoxelShape)TABLE_TOP, (VoxelShape)TABLE_BOTTOM_NORTH);
    protected static final VoxelShape TABLE_SHAPE_SOUTH = Shapes.m_83110_((VoxelShape)TABLE_TOP, (VoxelShape)TABLE_BOTTOM_SOUTH);
    protected static final VoxelShape TABLE_SHAPE_WEST = Shapes.m_83110_((VoxelShape)TABLE_TOP, (VoxelShape)TABLE_BOTTOM_WEST);
    protected static final VoxelShape TABLE_SHAPE_EAST = Shapes.m_83110_((VoxelShape)TABLE_TOP, (VoxelShape)TABLE_BOTTOM_EAST);

    public BlockFramingTable(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(PART, (Comparable)((Object)EnumFramingTablePart.RIGHT)));
    }

    public static Direction getTableDirection(BlockGetter getter, BlockPos pos) {
        BlockState state = getter.m_8055_(pos);
        return state.m_60734_() instanceof BlockFramingTable ? (Direction)state.m_61143_((Property)f_54117_) : null;
    }

    private static Direction getNeighborDirection(EnumFramingTablePart part, Direction direction) {
        return part == EnumFramingTablePart.LEFT ? direction.m_122427_() : direction.m_122428_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        EnumFramingTablePart part = (EnumFramingTablePart)((Object)state.m_61143_(PART));
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        return switch (facing) {
            case Direction.NORTH -> {
                if (part == EnumFramingTablePart.LEFT) {
                    yield TABLE_SHAPE_WEST;
                }
                yield TABLE_SHAPE_EAST;
            }
            case Direction.SOUTH -> {
                if (part == EnumFramingTablePart.LEFT) {
                    yield TABLE_SHAPE_EAST;
                }
                yield TABLE_SHAPE_WEST;
            }
            case Direction.WEST -> {
                if (part == EnumFramingTablePart.LEFT) {
                    yield TABLE_SHAPE_NORTH;
                }
                yield TABLE_SHAPE_SOUTH;
            }
            case Direction.EAST -> {
                if (part == EnumFramingTablePart.LEFT) {
                    yield TABLE_SHAPE_SOUTH;
                }
                yield TABLE_SHAPE_NORTH;
            }
            default -> TABLE_TOP;
        };
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            BlockFramingTable.preventCreativeDropFromLeft(level, pos, state, player);
            if (!player.m_7500_() && state.m_61143_(PART) != EnumFramingTablePart.RIGHT) {
                BlockFramingTable.m_49881_((BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)EnumFramingTablePart.RIGHT))), (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    protected static void preventCreativeDropFromLeft(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos pos2;
        BlockState state2;
        EnumFramingTablePart part = (EnumFramingTablePart)((Object)state.m_61143_(PART));
        if (part == EnumFramingTablePart.RIGHT) {
            BlockPos pos22 = pos.m_121945_(BlockFramingTable.getNeighborDirection(part, (Direction)state.m_61143_((Property)f_54117_)));
            BlockState state22 = level.m_8055_(pos22);
            if (state22.m_60713_(state.m_60734_()) && state22.m_61143_(PART) == EnumFramingTablePart.LEFT) {
                level.m_7731_(pos22, Blocks.f_50016_.m_49966_(), 35);
                level.m_5898_(player, 2001, pos22, Block.m_49956_((BlockState)state22));
            }
        } else if (part == EnumFramingTablePart.LEFT && (state2 = level.m_8055_(pos2 = pos.m_121945_(BlockFramingTable.getNeighborDirection(part, (Direction)state.m_61143_((Property)f_54117_))))).m_60713_(state.m_60734_()) && state2.m_61143_(PART) == EnumFramingTablePart.RIGHT) {
            level.m_7731_(pos2, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, pos2, Block.m_49956_((BlockState)state2));
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        Direction dirLeft = direction.m_122428_();
        BlockPos pos = context.m_8083_();
        BlockPos pos2 = pos.m_121945_(dirLeft);
        return context.m_43725_().m_8055_(pos2).m_60629_(context) && context.m_43725_().m_6857_().m_61937_(pos2) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    public static Direction getConnectedDirection(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        return state.m_61143_(PART) == EnumFramingTablePart.RIGHT ? direction.m_122424_() : direction;
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState state) {
        EnumFramingTablePart part = (EnumFramingTablePart)((Object)state.m_61143_(PART));
        return part == EnumFramingTablePart.RIGHT ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityFramingTable((BlockEntityType)ModBlockEntities.FRAMING_TABLE.get(), pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntityFramingTable blockEntity;
        super.m_6402_(level, pos, state, entity, stack);
        if (stack.m_41788_() && (blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityFramingTable.class)) != null) {
            blockEntity.customName().setName(stack.m_41786_());
        }
        if (!level.f_46443_) {
            Direction dirLeft = ((Direction)state.m_61143_((Property)f_54117_)).m_122428_();
            BlockPos pos2 = pos.m_121945_(dirLeft);
            level.m_7731_(pos2, (BlockState)state.m_61124_(PART, (Comparable)((Object)EnumFramingTablePart.LEFT)), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (state.m_61143_(PART) != EnumFramingTablePart.RIGHT) {
            pos = pos.m_121945_(BlockFramingTable.getNeighborDirection((EnumFramingTablePart)((Object)state.m_61143_(PART)), (Direction)state.m_61143_((Property)f_54117_)));
        }
        this.openUI(level, pos, player);
        return InteractionResult.CONSUME;
    }

    private void openUI(Level level, BlockPos pos, Player player) {
        BlockEntityFramingTable blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityFramingTable.class);
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)blockEntity, extraData -> extraData.m_130064_(pos));
    }
}

