/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BigBrickBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final BooleanProperty PAIRED = BooleanProperty.m_61465_((String)"paired");
    public final BrickType TYPE;

    public BigBrickBlock(BlockBehaviour.Properties properties) {
        this(properties, BrickType.STONE);
    }

    public BigBrickBlock(BlockBehaviour.Properties properties, BrickType type) {
        super(properties);
        this.TYPE = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)PAIRED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        BlockPos targetPos = context.m_8083_().m_121945_(face.m_122424_());
        BlockState targetState = context.m_43725_().m_8055_(targetPos);
        boolean pairing = context.m_43723_() != null && !context.m_43723_().m_6144_() && this.BrickMatches(this, targetState) && (Boolean)targetState.m_61143_((Property)PAIRED) == false;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_())).m_61124_((Property)PAIRED, (Comparable)Boolean.valueOf(pairing));
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (!worldIn.f_46443_) {
            if (placer != null && placer.m_6144_()) {
                return;
            }
            BlockPos blockpos = pos.m_121945_((Direction)state.m_61143_((Property)FACING));
            BlockState blockstate = worldIn.m_8055_(blockpos);
            if (this.BrickMatches(this, blockstate) && !((Boolean)blockstate.m_61143_((Property)PAIRED)).booleanValue()) {
                worldIn.m_7731_(blockpos, (BlockState)((BlockState)blockstate.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_61124_((Property)PAIRED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.m_6289_(pos, Blocks.f_50016_);
                state.m_60701_((LevelAccessor)worldIn, pos, 3);
            }
        }
    }

    private boolean BrickMatches(BigBrickBlock thisBlock, BlockState suspect) {
        Block block = suspect.m_60734_();
        if (block instanceof BigBrickBlock) {
            BigBrickBlock block2 = (BigBrickBlock)block;
            return block2.TYPE == thisBlock.TYPE;
        }
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.equals((Object)stateIn.m_61143_((Property)FACING)) && ((Boolean)stateIn.m_61143_((Property)PAIRED)).booleanValue() && !this.BrickMatches(this, worldIn.m_8055_(facingPos))) {
            return (BlockState)stateIn.m_61124_((Property)PAIRED, (Comparable)Boolean.valueOf(false));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PAIRED});
    }

    public static enum BrickType {
        STONE,
        END_STONE,
        DRIPSTONE,
        CALCITE,
        TUFF;

    }
}

