/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.datagen;

import architectspalette.core.datagen.WarpingRecipeBuilder;
import architectspalette.core.integration.APVerticalSlabsCondition;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.APItems;
import architectspalette.core.registry.util.BlockNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.RegistryObject;

public class APRecipes
extends RecipeProvider {
    private static final Map<String, Boolean> stonecuttingMap = new HashMap<String, Boolean>();

    public APRecipes(PackOutput pack) {
        super(pack);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        BlockNode.forAllBaseNodes(node -> APRecipes.processBlockNode(consumer, node));
        APRecipes.quickWarpingRecipe(consumer, APBlocks.ESOTERRACK.get(), Blocks.f_50334_, (ResourceKey<Level>)Level.f_46429_);
        APRecipes.quickWarpingRecipe(consumer, APBlocks.ONYX.get(), Blocks.f_50122_, (ResourceKey<Level>)Level.f_46429_);
        APRecipes.quickWarpingRecipe(consumer, APBlocks.NEBULITE.get(), Blocks.f_50228_, (ResourceKey<Level>)Level.f_46429_);
        APRecipes.quickWarpingRecipe(consumer, APBlocks.MOONSHALE.get(), Blocks.f_50069_, (ResourceKey<Level>)Level.f_46429_);
        APRecipes.quickWarpingRecipe(consumer, (Block)APBlocks.MOONSHALE.getChild(BlockNode.BlockType.BRICKS).get(), Blocks.f_50222_, (ResourceKey<Level>)Level.f_46429_);
        APRecipes.quickWarpingRecipe(consumer, APBlocks.CRATERSTONE.get(), Blocks.f_50652_, (ResourceKey<Level>)Level.f_46429_);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)APBlocks.SHEET_METAL.get(), (int)64).m_126130_("x").m_126130_("x").m_126127_(Character.valueOf('x'), (ItemLike)Items.f_41913_).m_126132_(APRecipes.m_176602_((ItemLike)Items.f_42416_), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)Items.f_42416_)).m_176498_(consumer);
        APRecipes.quickStonecuttingRecipe(consumer, (ItemLike)Items.f_42416_, (ItemLike)APBlocks.SHEET_METAL.get(), 4);
        APRecipes.quickStonecuttingRecipe(consumer, (ItemLike)Items.f_41913_, (ItemLike)APBlocks.SHEET_METAL.get(), 36);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)APBlocks.TREAD_PLATE.get(), (int)4).m_126130_(" x ").m_126130_("xyx").m_126130_(" x ").m_126127_(Character.valueOf('x'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('y'), (ItemLike)APBlocks.PLATING_BLOCK.get()).m_126132_(APRecipes.m_176602_((ItemLike)APBlocks.PLATING_BLOCK.get()), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)APBlocks.PLATING_BLOCK.get())).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)APBlocks.HAZARD_BLOCK.get(), (int)4).m_126130_("xy").m_126130_("yx").m_126127_(Character.valueOf('x'), (ItemLike)Blocks.f_50494_).m_126127_(Character.valueOf('y'), (ItemLike)Blocks.f_50505_).m_126132_(APRecipes.m_176602_((ItemLike)Blocks.f_50494_), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)Blocks.f_50494_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)APBlocks.BREAD_BLOCK.get(), (int)9).m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)Blocks.f_50335_).m_126132_(APRecipes.m_176602_((ItemLike)Items.f_42405_), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)Items.f_42405_)).m_176498_(consumer);
        APRecipes.brickRecipe((ItemLike)APBlocks.ORACLE_BLOCK.get(), (ItemLike)APItems.ORACLE_JELLY.get(), 8, consumer);
        APRecipes.brickRecipe((ItemLike)APBlocks.CEREBRAL_BLOCK.get(), (ItemLike)APItems.CEREBRAL_PLATE.get(), 8, consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)APBlocks.ORACLE_BLOCK.getChild(BlockNode.BlockType.SPECIAL).get()), (int)2).m_126130_("xyx").m_126127_(Character.valueOf('x'), (ItemLike)APItems.CEREBRAL_PLATE.get()).m_126127_(Character.valueOf('y'), (ItemLike)APBlocks.ORACLE_BLOCK.get()).m_126132_(APRecipes.m_176602_((ItemLike)APBlocks.ORACLE_BLOCK.get()), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)APBlocks.ORACLE_BLOCK.get())).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)APBlocks.ORACLE_BLOCK.getChild(BlockNode.BlockType.LAMP).get()), (int)2).m_126130_(" x ").m_126130_("xyx").m_126130_(" x ").m_126127_(Character.valueOf('x'), (ItemLike)APItems.ORACLE_JELLY.get()).m_126127_(Character.valueOf('y'), (ItemLike)Items.f_42001_).m_126132_(APRecipes.m_176602_((ItemLike)APBlocks.ORACLE_BLOCK.get()), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)APBlocks.ORACLE_BLOCK.get())).m_176498_(consumer);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)APItems.ORACLE_JELLY.get()), (int)4).m_126209_((ItemLike)Items.f_42730_).m_126209_((ItemLike)Items.f_151049_).m_126209_((ItemLike)Items.f_42501_).m_126132_(APRecipes.m_176602_((ItemLike)Items.f_151049_), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)Items.f_151049_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)APItems.CEREBRAL_PLATE.get()), (int)4).m_126209_((ItemLike)Blocks.f_152496_).m_126209_((ItemLike)Items.f_42692_).m_126209_((ItemLike)Items.f_42414_).m_126132_(APRecipes.m_176602_((ItemLike)Items.f_151048_), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)Items.f_151048_)).m_176498_(consumer);
        APRecipes.quickBlastingRecipe(consumer, (ItemLike)APItems.SUNMETAL_BRICK.get(), (ItemLike)APItems.SUNMETAL_BLEND.get());
        APRecipes.quickBlastingRecipe(consumer, (ItemLike)APItems.NETHER_BRASS.get(), (ItemLike)APItems.BRASS_BLEND.get());
        APRecipes.quickSmeltingRecipe(consumer, APBlocks.MOONSHALE, APBlocks.CRATERSTONE);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)APBlocks.MOONSHALE.getChild(BlockNode.BlockType.SPECIAL).get()), (int)2).m_126130_("s").m_126130_("b").m_126130_("s").m_126127_(Character.valueOf('s'), (ItemLike)Blocks.f_50404_).m_126127_(Character.valueOf('b'), (ItemLike)APBlocks.MOONSHALE).m_126132_(APRecipes.m_176602_((ItemLike)APBlocks.MOONSHALE), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)APBlocks.MOONSHALE)).m_176498_(consumer);
    }

    private static void processBlockNode(Consumer<FinishedRecipe> consumer, BlockNode node) {
        String hasBase = "has_" + node.getName();
        node.forEach(n -> {
            if (n.parent != null && !n.getFlag(BlockNode.ExcludeFlag.RECIPES)) {
                Block block = n.get();
                Block parent = n.parent.get();
                int stoneCuttingCount = APRecipes.getStoneCuttingCount(n.type);
                switch (n.type) {
                    case BRICKS: 
                    case POLISHED: {
                        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)4).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        RegistryObject<Block> tiles = n.getSibling(BlockNode.BlockType.TILES);
                        if (tiles == null) break;
                        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)4).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), (ItemLike)tiles.get()).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_126140_(consumer, APRecipes.modId(n.getName() + "_from_" + tiles.getId().m_135815_()));
                        break;
                    }
                    case CRACKED: {
                        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{parent}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (float)0.1f, (int)200).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_126140_(consumer, APRecipes.smeltingName((ItemLike)block, (ItemLike)parent));
                        break;
                    }
                    case MOSSY: {
                        break;
                    }
                    case TILES: {
                        RegistryObject<Block> bricks = n.getSibling(BlockNode.BlockType.BRICKS);
                        if (bricks == null) {
                            bricks = n.getSibling(BlockNode.BlockType.POLISHED);
                        }
                        if (bricks != null) {
                            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)4).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), (ItemLike)bricks.get()).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_126140_(consumer, APRecipes.modId(n.getName() + "_from_" + bricks.getId().m_135815_()));
                            break;
                        }
                        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)4).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case CHISELED: {
                        RegistryObject<Block> slab = n.getSibling(BlockNode.BlockType.SLAB);
                        if (slab == null) break;
                        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)1).m_126130_("x").m_126130_("x").m_126127_(Character.valueOf('x'), (ItemLike)slab.get()).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case PILLAR: {
                        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)2).m_126130_("x").m_126130_("x").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case NUB: {
                        break;
                    }
                    case SLAB: {
                        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)6).m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case VERTICAL_SLAB: {
                        stoneCuttingCount = 0;
                        Block slab = (Block)n.getSibling(BlockNode.BlockType.SLAB).get();
                        ConditionalRecipe.builder().addCondition((ICondition)APVerticalSlabsCondition.instance).addRecipe(c -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)3).m_126130_("x").m_126130_("x").m_126130_("x").m_126145_("vertical_slab").m_126127_(Character.valueOf('x'), (ItemLike)slab).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(c)).build(consumer, APRecipes.modId("vslabs/" + n.getName()));
                        ConditionalRecipe.builder().addCondition((ICondition)APVerticalSlabsCondition.instance).addRecipe(c -> ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (int)1).m_126145_("vertical_slab_revert").m_126209_((ItemLike)block).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(c)).build(consumer, APRecipes.modId("vslabs/" + n.getName() + "_revert"));
                        ConditionalRecipe.builder().addCondition((ICondition)APVerticalSlabsCondition.instance).addRecipe(c -> SingleItemRecipeBuilder.m_246944_((Ingredient)APRecipes.getStonecuttingIngredients(n), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)2).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(c)).build(consumer, APRecipes.modId("vslabs/stonecutting/" + n.getName()));
                        break;
                    }
                    case STAIRS: {
                        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)4).m_126130_("x  ").m_126130_("xx ").m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case WALL: {
                        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)6).m_126130_("xxx").m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case FENCE: {
                        break;
                    }
                    case PLATING: {
                        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)8).m_126130_("xxx").m_126130_("x x").m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                        break;
                    }
                    case DARK: {
                        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)8).m_126130_("xxx").m_126130_("xdx").m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)parent).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42498_).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_176498_(consumer);
                    }
                }
                if (stoneCuttingCount > 0 && (node.tool != BlockNode.Tool.AXE || n.type == BlockNode.BlockType.NUB)) {
                    SingleItemRecipeBuilder.m_246944_((Ingredient)APRecipes.getStonecuttingIngredients(n), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)stoneCuttingCount).m_126132_(hasBase, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{node.get()})).m_126140_(consumer, APRecipes.cuttingName((ItemLike)block, (ItemLike)parent));
                }
            }
        });
    }

    private static ResourceLocation smeltingName(ItemLike item, ItemLike from) {
        return new ResourceLocation("architects_palette", "smelting/" + APRecipes.m_176632_((ItemLike)item));
    }

    private static ResourceLocation cuttingName(ItemLike item, ItemLike from) {
        Object string = APRecipes.m_176632_((ItemLike)item);
        if (stonecuttingMap.put((String)string, true) != null) {
            string = (String)string + "_from_" + APRecipes.m_176632_((ItemLike)from);
        }
        return new ResourceLocation("architects_palette", "stonecutting/" + (String)string);
    }

    private static ResourceLocation warpingName(Block item, Block from) {
        return new ResourceLocation("architects_palette", "warping/" + APRecipes.m_176632_((ItemLike)item) + "_from_" + APRecipes.m_176632_((ItemLike)from) + "_warping");
    }

    private static ResourceLocation blastingName(ItemLike item, ItemLike from) {
        return new ResourceLocation("architects_palette", "blasting/" + APRecipes.m_176632_((ItemLike)item) + "_from_" + APRecipes.m_176632_((ItemLike)from) + "_blasting");
    }

    private static void quickWarpingRecipe(Consumer<FinishedRecipe> consumer, Block result, Block from, ResourceKey<Level> dimension) {
        new WarpingRecipeBuilder(result.m_5456_(), dimension, Ingredient.m_43929_((ItemLike[])new ItemLike[]{from})).m_126132_(APRecipes.m_176602_((ItemLike)from), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)from)).m_126140_(consumer, APRecipes.warpingName(result, from));
    }

    private static void quickBlastingRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike from) {
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{from}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (float)0.1f, (int)100).m_126132_(APRecipes.m_176602_((ItemLike)from), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)from)).m_126140_(consumer, APRecipes.blastingName(result, from));
    }

    private static void quickSmeltingRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike from) {
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{from}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (float)0.1f, (int)200).m_126132_(APRecipes.m_176602_((ItemLike)from), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)from)).m_126140_(consumer, APRecipes.smeltingName(result, from));
    }

    private static void quickStonecuttingRecipe(Consumer<FinishedRecipe> consumer, ItemLike from, ItemLike result) {
        APRecipes.quickStonecuttingRecipe(consumer, result, from, 1);
    }

    private static void quickStonecuttingRecipe(Consumer<FinishedRecipe> consumer, ItemLike from, ItemLike result, int amount) {
        SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{from}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)amount).m_126132_(APRecipes.m_176602_((ItemLike)from), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)from)).m_126140_(consumer, APRecipes.cuttingName(result, from));
    }

    private static Ingredient getStonecuttingIngredients(BlockNode node) {
        ArrayList<BlockNode> list = new ArrayList<BlockNode>();
        BlockNode last = node;
        while (last.parent != null && APRecipes.getStoneCuttingCount(last.type) > 0) {
            list.add(last.parent);
            last = last.parent;
        }
        Stream<ItemStack> stream = list.stream().map(n -> new ItemStack((ItemLike)n.get().m_5456_()));
        return Ingredient.m_43921_(stream);
    }

    private static Ingredient getParentIngredients(BlockNode node) {
        Stream<ItemStack> stream = node.getParents().stream().map(n -> new ItemStack((ItemLike)n.get().m_5456_()));
        return Ingredient.m_43921_(stream);
    }

    private static ResourceLocation modId(String name) {
        return new ResourceLocation("architects_palette", name);
    }

    private static int getStoneCuttingCount(BlockNode.BlockType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case BlockNode.BlockType.BASE, BlockNode.BlockType.CRACKED, BlockNode.BlockType.MOSSY, BlockNode.BlockType.LAMP, BlockNode.BlockType.DARK, BlockNode.BlockType.SPECIAL -> 0;
            case BlockNode.BlockType.BRICKS, BlockNode.BlockType.FENCE, BlockNode.BlockType.TILES, BlockNode.BlockType.CHISELED, BlockNode.BlockType.PILLAR, BlockNode.BlockType.STAIRS, BlockNode.BlockType.WALL, BlockNode.BlockType.PLATING, BlockNode.BlockType.POLISHED -> 1;
            case BlockNode.BlockType.NUB, BlockNode.BlockType.SLAB, BlockNode.BlockType.VERTICAL_SLAB -> 2;
        };
    }

    private static void brickRecipe(ItemLike result, ItemLike ingredient, int count, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), ingredient).m_126132_(APRecipes.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)APRecipes.m_125977_((ItemLike)ingredient)).m_176498_(consumer);
    }
}

