/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork;

import com.simibubi.create.foundation.particle.ICustomParticleData;
import com.simibubi.create.foundation.utility.Lang;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.valkyrienskies.clockwork.content.curiosities.particles.PhysLightningParticle;
import org.valkyrienskies.clockwork.platform.api.DeferredRegister;

public enum ClockworkParticles {
    PHYS_LIGHTNING(PhysLightningParticle.Data::new);

    private final ParticleEntry<?> entry;

    private <D extends ParticleOptions> ClockworkParticles(Supplier<? extends ICustomParticleData<D>> typeFactory) {
        String name = Lang.asId((String)this.name());
        this.entry = new ParticleEntry(name, typeFactory);
    }

    public static void init() {
        ParticleEntry.REGISTER.registerAll();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        ParticleEngine particles = Minecraft.m_91087_().f_91061_;
        for (ClockworkParticles particle : ClockworkParticles.values()) {
            particle.entry.registerFactory(particles);
        }
    }

    public ParticleType<?> get() {
        return this.entry.object;
    }

    public String parameter() {
        return this.entry.name;
    }

    private static class ParticleEntry<D extends ParticleOptions> {
        private static final DeferredRegister<ParticleType<?>> REGISTER = DeferredRegister.create(BuiltInRegistries.f_257034_, "vs_clockwork");
        private final String name;
        private final Supplier<? extends ICustomParticleData<D>> typeFactory;
        private final ParticleType<D> object;

        public ParticleEntry(String name, Supplier<? extends ICustomParticleData<D>> typeFactory) {
            this.name = name;
            this.typeFactory = typeFactory;
            this.object = this.typeFactory.get().createType();
            REGISTER.register(name, () -> this.object);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void registerFactory(ParticleEngine particles) {
            this.typeFactory.get().register(this.object, particles);
        }
    }
}

