/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.flap;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.content.contraptions.flap.FlapBearingBlock;
import org.valkyrienskies.clockwork.content.contraptions.flap.contraption.FlapContraption;
import org.valkyrienskies.clockwork.util.ClockworkConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\f\u0010e\u001a\b\u0012\u0002\b\u0003\u0018\u00010d\u0012\u0006\u0010\u001f\u001a\u00020\u0011\u0012\u0006\u0010g\u001a\u00020f\u00a2\u0006\u0004\bh\u0010iJ\u001d\u0010\u0007\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\nJ\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010!\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020#H\u0016\u00a2\u0006\u0004\b$\u0010%J\r\u0010&\u001a\u00020\u0014\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b(\u0010'J\u000f\u0010)\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b)\u0010'J\u000f\u0010*\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b*\u0010\nJ\u0017\u0010,\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b.\u0010\nJ\u001f\u00102\u001a\u00020\u00062\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\u0014H\u0014\u00a2\u0006\u0004\b2\u00103J\u000f\u00104\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b4\u0010\nJ\u0017\u00106\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b6\u0010-J\u000f\u00107\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b7\u0010\nJ\u001f\u00108\u001a\u00020\u00062\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b8\u00103R\u0011\u0010;\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\"\u0010<\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u0010=\u001a\u0004\b>\u0010'\"\u0004\b?\u0010@R\"\u0010A\u001a\u00020\u00178\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010B\u001a\u0004\bC\u0010:\"\u0004\bD\u0010-R\"\u0010E\u001a\u00020\u00178\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010B\u001a\u0004\bF\u0010:\"\u0004\bG\u0010-R$\u0010H\u001a\u0004\u0018\u00010\f8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010\u000fR\u0011\u0010N\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\bM\u0010:R*\u0010P\u001a\u00020\u00142\u0006\u0010O\u001a\u00020\u00148\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bP\u0010=\u001a\u0004\bP\u0010'\"\u0004\bQ\u0010@R$\u0010S\u001a\u0004\u0018\u00010R8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bS\u0010T\u001a\u0004\bU\u0010V\"\u0004\bW\u0010XR\u0016\u0010Y\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bY\u0010BR\u0016\u0010Z\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bZ\u0010[R\u0018\u0010\\\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\\\u0010]R\"\u0010^\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b^\u0010=\u001a\u0004\b_\u0010'\"\u0004\b`\u0010@R\"\u0010a\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\ba\u0010=\u001a\u0004\bb\u0010'\"\u0004\bc\u0010@\u00a8\u0006j"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/flap/FlapBearingBlockEntity;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "Lcom/simibubi/create/content/contraptions/bearing/IBearingBlockEntity;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "applyRotations", "()V", "assemble", "Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "contraption", "attach", "(Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;)V", "disassemble", "Lnet/minecraft/core/BlockPos;", "getBlockPosition", "()Lnet/minecraft/core/BlockPos;", "", "negativeActivated", "positiveActivated", "", "getFlapTarget", "(ZZ)F", "partialTicks", "getInterpolatedAngle", "(F)F", "Lnet/minecraft/world/level/Level;", "worldIn", "pos", "", "getPower", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;", "isAttachedTo", "(Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;)Z", "isFlap", "()Z", "isValid", "isWoodenTop", "lazyTick", "prevSpeed", "onSpeedChanged", "(F)V", "onStall", "Lnet/minecraft/nbt/CompoundTag;", "compound", "clientPacket", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "remove", "forcedAngle", "setAngle", "tick", "write", "getAngularSpeed", "()F", "angularSpeed", "assembleNextTick", "Z", "getAssembleNextTick", "setAssembleNextTick", "(Z)V", "bearingAngle", "F", "getBearingAngle", "setBearingAngle", "clientAngleDiff", "getClientAngleDiff", "setClientAngleDiff", "flap", "Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "getFlap", "()Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "setFlap", "getFlapSpeed", "flapSpeed", "<set-?>", "isRunning", "setRunning", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "lastException", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "getLastException", "()Lcom/simibubi/create/content/contraptions/AssemblyException;", "setLastException", "(Lcom/simibubi/create/content/contraptions/AssemblyException;)V", "prevForcedAngle", "redstoneLevel", "I", "redstonePos", "Lnet/minecraft/core/BlockPos;", "redstoneSideOne", "getRedstoneSideOne", "setRedstoneSideOne", "redstoneSideTwo", "getRedstoneSideTwo", "setRedstoneSideTwo", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class FlapBearingBlockEntity
extends KineticBlockEntity
implements IBearingBlockEntity {
    private boolean redstoneSideOne;
    private boolean redstoneSideTwo;
    private float bearingAngle;
    private float clientAngleDiff;
    private boolean isRunning;
    private boolean assembleNextTick;
    @Nullable
    private AssemblyException lastException;
    @Nullable
    private ControlledContraptionEntity flap;
    private float prevForcedAngle;
    private int redstoneLevel;
    @Nullable
    private BlockPos redstonePos;

    public FlapBearingBlockEntity(@Nullable BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
    }

    public final boolean getRedstoneSideOne() {
        return this.redstoneSideOne;
    }

    public final void setRedstoneSideOne(boolean bl) {
        this.redstoneSideOne = bl;
    }

    public final boolean getRedstoneSideTwo() {
        return this.redstoneSideTwo;
    }

    public final void setRedstoneSideTwo(boolean bl) {
        this.redstoneSideTwo = bl;
    }

    protected final float getBearingAngle() {
        return this.bearingAngle;
    }

    protected final void setBearingAngle(float f) {
        this.bearingAngle = f;
    }

    protected final float getClientAngleDiff() {
        return this.clientAngleDiff;
    }

    protected final void setClientAngleDiff(float f) {
        this.clientAngleDiff = f;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    protected final void setRunning(boolean bl) {
        this.isRunning = bl;
    }

    public final boolean getAssembleNextTick() {
        return this.assembleNextTick;
    }

    public final void setAssembleNextTick(boolean bl) {
        this.assembleNextTick = bl;
    }

    @Nullable
    protected final AssemblyException getLastException() {
        return this.lastException;
    }

    protected final void setLastException(@Nullable AssemblyException assemblyException) {
        this.lastException = assemblyException;
    }

    @Nullable
    protected final ControlledContraptionEntity getFlap() {
        return this.flap;
    }

    protected final void setFlap(@Nullable ControlledContraptionEntity controlledContraptionEntity) {
        this.flap = controlledContraptionEntity;
    }

    public void addBehaviours(@NotNull List<? extends BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        super.addBehaviours(behaviours);
    }

    public final boolean isFlap() {
        return true;
    }

    private final int getPower(Level worldIn, BlockPos pos) {
        int power = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Iterate.directions, (String)"directions");
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.m_277185_(pos.m_121945_(direction), direction), power);
            if (power == 0) continue;
            this.redstonePos = pos.m_121945_(direction);
            break;
        }
        if (power == 0) {
            this.redstonePos = null;
        }
        return power;
    }

    public void tick() {
        block17: {
            block16: {
                super.tick();
                if (this.flap != null) {
                    ControlledContraptionEntity controlledContraptionEntity = this.flap;
                    Intrinsics.checkNotNull((Object)controlledContraptionEntity);
                    controlledContraptionEntity.m_8119_();
                }
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                if (level.f_46443_) {
                    this.prevForcedAngle = this.bearingAngle;
                    this.clientAngleDiff /= 2.0f;
                }
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                BlockPos blockPos = this.f_58858_;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                this.redstoneLevel = this.getPower(level2, blockPos);
                if (this.redstonePos != null) {
                    if (this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_) == Direction.UP || this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_) == Direction.DOWN) {
                        this.redstoneSideOne = Intrinsics.areEqual((Object)this.redstonePos, (Object)this.f_58858_.m_5484_(Direction.EAST, 1));
                        this.redstoneSideTwo = Intrinsics.areEqual((Object)this.redstonePos, (Object)this.f_58858_.m_5484_(Direction.WEST, 1));
                    } else if (this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_) == Direction.NORTH || this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_) == Direction.SOUTH) {
                        this.redstoneSideOne = Intrinsics.areEqual((Object)this.redstonePos, (Object)this.f_58858_.m_5484_(Direction.EAST, 1));
                        this.redstoneSideTwo = Intrinsics.areEqual((Object)this.redstonePos, (Object)this.f_58858_.m_5484_(Direction.WEST, 1));
                    } else if (this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_) == Direction.EAST || this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_) == Direction.WEST) {
                        this.redstoneSideOne = Intrinsics.areEqual((Object)this.redstonePos, (Object)this.f_58858_.m_5484_(Direction.NORTH, 1));
                        this.redstoneSideTwo = Intrinsics.areEqual((Object)this.redstonePos, (Object)this.f_58858_.m_5484_(Direction.SOUTH, 1));
                    }
                }
                Level level3 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level3);
                if (!level3.f_46443_ && this.assembleNextTick) {
                    this.assembleNextTick = false;
                    if (this.isRunning) {
                        boolean canDisassemble = true;
                        if (this.speed == 0.0f) {
                            if (this.flap != null) {
                                ControlledContraptionEntity controlledContraptionEntity = this.flap;
                                Intrinsics.checkNotNull((Object)controlledContraptionEntity);
                                controlledContraptionEntity.getContraption().stop(this.f_58857_);
                            }
                            this.disassemble();
                        }
                        return;
                    }
                    this.assemble();
                    return;
                }
                if (this.flap == null) break block16;
                ControlledContraptionEntity controlledContraptionEntity = this.flap;
                Intrinsics.checkNotNull((Object)controlledContraptionEntity);
                if (controlledContraptionEntity.isStalled()) break block17;
            }
            float testSpeed = this.getAngularSpeed() / 2.0f;
            float newAngle = this.bearingAngle + this.getFlapSpeed();
            this.bearingAngle = newAngle % (float)360;
        }
        if (!this.isRunning) {
            return;
        }
        this.applyRotations();
    }

    public void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.m_128379_(ClockworkConstants.Nbt.INSTANCE.getRUNNING(), this.isRunning);
        compound.m_128350_(ClockworkConstants.Nbt.INSTANCE.getANGLE(), this.bearingAngle);
        AssemblyException.write((CompoundTag)compound, (AssemblyException)this.lastException);
        super.write(compound, clientPacket);
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        float angleBefore = this.bearingAngle;
        this.isRunning = compound.m_128471_(ClockworkConstants.Nbt.INSTANCE.getRUNNING());
        this.bearingAngle = compound.m_128457_(ClockworkConstants.Nbt.INSTANCE.getANGLE());
        this.lastException = AssemblyException.read((CompoundTag)compound);
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.isRunning) {
            this.clientAngleDiff = AngleHelper.getShortestAngleDiff((double)angleBefore, (double)this.bearingAngle);
            this.bearingAngle = angleBefore;
        } else {
            this.flap = null;
        }
    }

    public final void assemble() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!(level.m_8055_(this.f_58858_).m_60734_() instanceof FlapBearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        FlapContraption contraption = null;
        try {
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2);
            BlockPos blockPos = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
            Intrinsics.checkNotNull((Object)direction);
            contraption = FlapContraption.Companion.assembleFlap(level2, blockPos, direction);
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (contraption == null) {
            return;
        }
        if (contraption.getBlocks().isEmpty()) {
            return;
        }
        BlockPos anchor = this.f_58858_.m_121945_(direction);
        contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
        ControlledContraptionEntity controlledContraptionEntity = this.flap = ControlledContraptionEntity.create((Level)this.f_58857_, (IControlContraption)((IControlContraption)this), (Contraption)contraption);
        Intrinsics.checkNotNull((Object)controlledContraptionEntity);
        controlledContraptionEntity.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        ControlledContraptionEntity controlledContraptionEntity2 = this.flap;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity2);
        controlledContraptionEntity2.setRotationAxis(direction.m_122434_());
        Level level3 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level3);
        ControlledContraptionEntity controlledContraptionEntity3 = this.flap;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity3);
        level3.m_7967_((Entity)controlledContraptionEntity3);
        this.isRunning = true;
        this.bearingAngle = 0.0f;
        this.sendData();
    }

    public void remove() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.disassemble();
        }
        super.remove();
    }

    public final void disassemble() {
        if (!this.isRunning && this.flap == null) {
            return;
        }
        this.bearingAngle = 0.0f;
        this.applyRotations();
        if (this.flap != null) {
            ControlledContraptionEntity controlledContraptionEntity = this.flap;
            Intrinsics.checkNotNull((Object)controlledContraptionEntity);
            controlledContraptionEntity.disassemble();
        }
        this.flap = null;
        this.isRunning = false;
        this.sendData();
    }

    protected final void applyRotations() {
        BlockState blockState = this.m_58900_();
        Direction.Axis axis = Direction.Axis.X;
        if (blockState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            axis = ((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_();
        }
        if (this.flap != null) {
            ControlledContraptionEntity controlledContraptionEntity = this.flap;
            Intrinsics.checkNotNull((Object)controlledContraptionEntity);
            controlledContraptionEntity.setAngle(this.bearingAngle);
            ControlledContraptionEntity controlledContraptionEntity2 = this.flap;
            Intrinsics.checkNotNull((Object)controlledContraptionEntity2);
            controlledContraptionEntity2.setRotationAxis(axis);
        }
    }

    public void attach(@NotNull ControlledContraptionEntity contraption) {
        Intrinsics.checkNotNullParameter((Object)contraption, (String)"contraption");
        BlockState blockState = this.m_58900_();
        if (!(contraption.getContraption() instanceof FlapContraption)) {
            return;
        }
        if (!blockState.m_61138_((Property)BearingBlock.FACING)) {
            return;
        }
        this.flap = contraption;
        this.m_6596_();
        BlockPos anchor = this.f_58858_.m_121945_((Direction)blockState.m_61143_((Property)BearingBlock.FACING));
        ControlledContraptionEntity controlledContraptionEntity = this.flap;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity);
        controlledContraptionEntity.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.isRunning = true;
            this.sendData();
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.flap != null) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (!level.f_46443_) {
                this.sendData();
            }
        }
    }

    public final float getFlapSpeed() {
        float speed = this.getAngularSpeed() / 2.0f;
        if (!(speed == 0.0f)) {
            float flapTarget = this.getFlapTarget(this.redstoneSideOne, this.redstoneSideTwo);
            float shortestAngleDiff = AngleHelper.getShortestAngleDiff((double)this.bearingAngle, (double)flapTarget);
            speed = shortestAngleDiff < 0.0f ? Math.max(speed, shortestAngleDiff) : Math.min(-speed, shortestAngleDiff);
        }
        return speed + this.clientAngleDiff / 3.0f;
    }

    protected final float getFlapTarget(boolean negativeActivated, boolean positiveActivated) {
        if (negativeActivated && !positiveActivated) {
            return -22.5f * ((float)this.redstoneLevel / (float)15);
        }
        if (positiveActivated && !negativeActivated) {
            return 22.5f * ((float)this.redstoneLevel / (float)15);
        }
        return negativeActivated && positiveActivated ? 0.0f : 0.0f;
    }

    public void setAngle(float forcedAngle) {
        this.bearingAngle = forcedAngle;
    }

    public final float getAngularSpeed() {
        float speed = -Math.abs(this.getSpeed() * (float)3 / 10.0f);
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            speed *= ServerSpeedProvider.get();
        }
        return speed;
    }

    public float getInterpolatedAngle(float partialTicks) {
        float partialTicks2;
        block5: {
            block4: {
                partialTicks2 = partialTicks;
                if (this.isVirtual()) {
                    return Mth.m_14179_((float)partialTicks2, (float)this.prevForcedAngle, (float)this.bearingAngle);
                }
                if (this.flap == null) break block4;
                ControlledContraptionEntity controlledContraptionEntity = this.flap;
                Intrinsics.checkNotNull((Object)controlledContraptionEntity);
                if (!controlledContraptionEntity.isStalled()) break block5;
            }
            partialTicks2 = 0.0f;
        }
        return Mth.m_14179_((float)partialTicks2, (float)this.bearingAngle, (float)(this.bearingAngle + this.getFlapSpeed()));
    }

    public boolean isWoodenTop() {
        return false;
    }

    public boolean isAttachedTo(@NotNull AbstractContraptionEntity contraption) {
        Intrinsics.checkNotNullParameter((Object)contraption, (String)"contraption");
        return !(contraption.getContraption() instanceof FlapContraption) ? false : this.flap == contraption;
    }

    public void onStall() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.sendData();
        }
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
    }

    public boolean isValid() {
        return !this.m_58901_();
    }

    @NotNull
    public BlockPos getBlockPosition() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        return blockPos;
    }
}

