/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.phys.bearing;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.PhysBearingBlockEntity;
import org.valkyrienskies.clockwork.util.render.RenderUtil;
import org.valkyrienskies.clockwork.util.render.TransformData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J-\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0010\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0011JA\u0010\u001a\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ/\u0010!\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010#\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010%\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b%\u0010$J\u001f\u0010&\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b&\u0010$J\u001f\u0010'\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b'\u0010$J/\u0010(\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b(\u0010\"\u00a8\u0006-"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingRenderer;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity;", "Lcom/simibubi/create/foundation/render/SuperByteBuffer;", "buffer", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "be", "", "angle", "", "light", "coolKineticRotationTransform", "(Lcom/simibubi/create/foundation/render/SuperByteBuffer;Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;FI)Lcom/simibubi/create/foundation/render/SuperByteBuffer;", "te", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "getRotatedModel", "(Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity;Lnet/minecraft/world/level/block/state/BlockState;)Lcom/simibubi/create/foundation/render/SuperByteBuffer;", "getRotatedModelAttacher", "blockEntity", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "physPartial", "Lnet/minecraft/world/phys/Vec3;", "pivot", "Lnet/minecraft/core/Direction;", "axl", "rotateAndRise", "(Lcom/simibubi/create/foundation/render/SuperByteBuffer;Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/core/Direction;)V", "rotateAndRiseNorth", "(Lcom/simibubi/create/foundation/render/SuperByteBuffer;Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity;)V", "rotateAndRiseSouth", "rotateEastWing", "rotateWestWing", "rotateWing", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "clockwork"})
public final class PhysBearingRenderer
extends KineticBlockEntityRenderer<PhysBearingBlockEntity> {
    public PhysBearingRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    protected void renderSafe(@Nullable PhysBearingBlockEntity blockEntity, float partialTicks, @NotNull PoseStack matrices, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.renderSafe((KineticBlockEntity)blockEntity, partialTicks, matrices, buffer, light, overlay);
        if (blockEntity == null) {
            return;
        }
        BlockState blockState = blockEntity.m_58900_();
        Direction facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        SuperByteBuffer phys_north = CachedBufferer.partial((PartialModel)ClockworkPartials.INSTANCE.getPHYS_NORTH_WING(), (BlockState)blockState);
        SuperByteBuffer phys_south = CachedBufferer.partial((PartialModel)ClockworkPartials.INSTANCE.getPHYS_SOUTH_WING(), (BlockState)blockState);
        SuperByteBuffer phys_west = CachedBufferer.partial((PartialModel)ClockworkPartials.INSTANCE.getPHYS_WEST_WING(), (BlockState)blockState);
        SuperByteBuffer phys_east = CachedBufferer.partial((PartialModel)ClockworkPartials.INSTANCE.getPHYS_EAST_WING(), (BlockState)blockState);
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.5, 0.5);
        matrices.m_252781_(new Quaternionf().rotationXYZ(0.0f, (float)Math.toRadians(-180.0), 0.0f));
        Direction direction = facing;
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                matrices.m_252781_(Axis.f_252529_.m_252977_(270.0f));
                break;
            }
            case 2: {
                matrices.m_252781_(Axis.f_252403_.m_252977_(270.0f));
                matrices.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case 3: {
                matrices.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case 4: {
                matrices.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                matrices.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case 5: {
                matrices.m_252781_(Axis.f_252529_.m_252977_(0.0f));
                break;
            }
            case 6: {
                matrices.m_252781_(Axis.f_252495_.m_252977_(180.0f));
            }
        }
        matrices.m_85837_(-0.5, -0.5, -0.5);
        float interpolatedAngle = blockEntity.getInterpolatedCoreAngle(AnimationTickHolder.getPartialTicks() - 1.0f);
        Intrinsics.checkNotNull((Object)facing);
        Vector3f offset = switch (WhenMappings.$EnumSwitchMapping$0[facing.ordinal()]) {
            case 1 -> new Vector3f(0.0f, 0.0f, 0.1f);
            case 2 -> new Vector3f(0.1f, 0.0f, 0.0f);
            case 3 -> new Vector3f(0.0f, 0.0f, 0.1f);
            case 4 -> new Vector3f(0.1f, 0.0f, 0.0f);
            case 5 -> new Vector3f(0.0f, 0.1f, 0.0f);
            case 6 -> new Vector3f(0.0f, 0.1f, 0.0f);
            default -> throw new NoWhenBranchMatchedException();
        };
        TransformData innerData = new TransformData(offset, new Vector3f(interpolatedAngle, interpolatedAngle, 0.0f));
        TransformData data = new TransformData(offset, new Vector3f(0.0f, 0.0f, 0.0f));
        TransformData outerData = new TransformData(offset, new Vector3f(0.0f, 0.0f, 0.0f));
        Intrinsics.checkNotNull((Object)blockState);
        RenderUtil.INSTANCE.renderCubeMatrix(matrices, buffer, blockState, innerData, data, outerData, 1.5f, light);
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110466_());
        Intrinsics.checkNotNull((Object)phys_north);
        this.rotateAndRiseNorth(phys_north, blockEntity);
        Intrinsics.checkNotNull((Object)phys_south);
        this.rotateAndRiseSouth(phys_south, blockEntity);
        Intrinsics.checkNotNull((Object)phys_west);
        this.rotateWestWing(phys_west, blockEntity);
        Intrinsics.checkNotNull((Object)phys_east);
        this.rotateEastWing(phys_east, blockEntity);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110466_());
        phys_north.renderInto(matrices, vertexConsumer);
        phys_south.renderInto(matrices, vertexConsumer);
        phys_west.renderInto(matrices, vertexConsumer);
        phys_east.renderInto(matrices, vertexConsumer);
        matrices.m_85849_();
        matrices.m_85836_();
        SuperByteBuffer at = this.getRotatedModelAttacher(blockEntity, blockState);
        SuperByteBuffer shaf = this.getRotatedModel(blockEntity, blockState);
        Block block = blockState.m_60734_();
        Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type com.simibubi.create.content.kinetics.base.IRotate");
        Direction.Axis axis = ((IRotate)block).getRotationAxis(blockState);
        float angle = KineticBlockEntityRenderer.getAngleForTe((KineticBlockEntity)((KineticBlockEntity)blockEntity), (BlockPos)blockEntity.m_58899_(), (Direction.Axis)axis);
        this.coolKineticRotationTransform(at, (KineticBlockEntity)blockEntity, angle, light).renderInto(matrices, vertexConsumer);
        this.coolKineticRotationTransform(shaf, (KineticBlockEntity)blockEntity, angle, light).renderInto(matrices, vertexConsumer);
        matrices.m_85849_();
    }

    @NotNull
    public final SuperByteBuffer coolKineticRotationTransform(@NotNull SuperByteBuffer buffer, @NotNull KineticBlockEntity be, float angle, int light) {
        Direction facing;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        buffer.light(light);
        Direction direction = facing = (Direction)be.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 5: 
            case 6: {
                buffer.rotate(90.0, Direction.Axis.X);
                buffer.translate(0.0, 0.0, -1.0);
                break;
            }
            case 3: {
                buffer.rotate(-90.0, Direction.Axis.X);
                buffer.translate(0.0, -1.0, 0.0);
                break;
            }
            case 1: {
                buffer.rotate(90.0, Direction.Axis.X);
                buffer.translate(0.0, 0.0, -1.0);
                break;
            }
            case 2: {
                buffer.rotate(90.0, Direction.Axis.Z);
                buffer.translate(0.0, -1.0, 0.0);
                break;
            }
            case 4: {
                buffer.rotate(-90.0, Direction.Axis.Z);
                buffer.translate(-1.0, 0.0, 0.0);
            }
        }
        Direction.AxisDirection axlDir = Direction.AxisDirection.NEGATIVE;
        Direction.Axis axl = Direction.Axis.Y;
        if (facing == Direction.UP || facing == Direction.DOWN) {
            axl = Direction.Axis.Z;
        }
        if (facing == Direction.EAST || facing == Direction.SOUTH) {
            axlDir = Direction.AxisDirection.POSITIVE;
        }
        buffer.rotateCentered(Direction.m_122390_((Direction.AxisDirection)axlDir, (Direction.Axis)axl), angle);
        return buffer;
    }

    private final void rotateAndRiseNorth(SuperByteBuffer physPartial, PhysBearingBlockEntity blockEntity) {
        Vec3 pivot = new Vec3(0.0, -0.4375, -0.34375);
        this.rotateAndRise(physPartial, blockEntity, pivot, Direction.WEST);
    }

    private final void rotateAndRiseSouth(SuperByteBuffer physPartial, PhysBearingBlockEntity blockEntity) {
        Vec3 pivot = new Vec3(0.0, -0.4375, 0.34375);
        this.rotateAndRise(physPartial, blockEntity, pivot, Direction.EAST);
    }

    private final void rotateAndRise(SuperByteBuffer physPartial, PhysBearingBlockEntity blockEntity, Vec3 pivot, Direction axl) {
        float interpolatedAngle = blockEntity.getWingRotOffset();
        physPartial.translate(pivot);
        physPartial.rotateCentered(axl, (float)((double)(interpolatedAngle / (float)360) * Math.PI));
        physPartial.translateBack(pivot);
    }

    private final void rotateWestWing(SuperByteBuffer physPartial, PhysBearingBlockEntity blockEntity) {
        Vec3 pivot = new Vec3(-0.4375, 0.0625, 0.0);
        this.rotateWing(physPartial, blockEntity, pivot, Direction.SOUTH);
    }

    private final void rotateEastWing(SuperByteBuffer physPartial, PhysBearingBlockEntity blockEntity) {
        Vec3 pivot = new Vec3(0.4375, 0.0625, 0.0);
        this.rotateWing(physPartial, blockEntity, pivot, Direction.NORTH);
    }

    private final void rotateWing(SuperByteBuffer physPartial, PhysBearingBlockEntity blockEntity, Vec3 pivot, Direction axl) {
        float interpolatedAngle = blockEntity.getWingRotOffset();
        physPartial.translate(pivot);
        physPartial.rotateCentered(axl, (float)((double)(interpolatedAngle / (float)360) * Math.PI));
        physPartial.translateBack(pivot);
    }

    @NotNull
    protected SuperByteBuffer getRotatedModel(@NotNull PhysBearingBlockEntity te, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)te, (String)"te");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        SuperByteBuffer superByteBuffer = CachedBufferer.partialFacing((PartialModel)ClockworkPartials.INSTANCE.getPHYS_SHAFT(), (BlockState)state, (Direction)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
        Intrinsics.checkNotNullExpressionValue((Object)superByteBuffer, (String)"partialFacing(...)");
        return superByteBuffer;
    }

    @NotNull
    public final SuperByteBuffer getRotatedModelAttacher(@NotNull PhysBearingBlockEntity te, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)te, (String)"te");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        SuperByteBuffer superByteBuffer = CachedBufferer.partialFacing((PartialModel)ClockworkPartials.INSTANCE.getPHYS_ATTACHER(), (BlockState)state, (Direction)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
        Intrinsics.checkNotNullExpressionValue((Object)superByteBuffer, (String)"partialFacing(...)");
        return superByteBuffer;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.SOUTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

