/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.phys.gyro;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.content.contraptions.phys.gyro.GyroBlockEntity;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0018\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u000b\u0010\nJ\u000f\u0010\f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\nJ\u000f\u0010\r\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\nR\u0016\u0010\u000e\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroInstance;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityInstance;", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroBlockEntity;", "Lcom/jozufozu/flywheel/api/instance/DynamicInstance;", "", "angle", "", "animate", "(F)V", "beginFrame", "()V", "remove", "update", "updateLight", "lastAngle", "F", "Lcom/simibubi/create/content/kinetics/base/flwdata/RotatingData;", "shaft", "Lcom/simibubi/create/content/kinetics/base/flwdata/RotatingData;", "Lcom/jozufozu/flywheel/core/materials/model/ModelData;", "wheel", "Lcom/jozufozu/flywheel/core/materials/model/ModelData;", "Lcom/jozufozu/flywheel/api/MaterialManager;", "materialManager", "blockEntity", "<init>", "(Lcom/jozufozu/flywheel/api/MaterialManager;Lorg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroBlockEntity;)V", "clockwork"})
public final class GyroInstance
extends KineticBlockEntityInstance<GyroBlockEntity>
implements DynamicInstance {
    @NotNull
    private final RotatingData shaft;
    @NotNull
    private final ModelData wheel;
    private float lastAngle;

    public GyroInstance(@NotNull MaterialManager materialManager, @NotNull GyroBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)materialManager, (String)"materialManager");
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        super(materialManager, (KineticBlockEntity)blockEntity);
        RotatingData rotatingData = this.setup((RotatingData)this.getRotatingMaterial().getModel(this.shaft()).createInstance());
        Intrinsics.checkNotNullExpressionValue((Object)rotatingData, (String)"setup(...)");
        this.shaft = rotatingData;
        InstanceData instanceData = this.getTransformMaterial().getModel(this.blockState).createInstance();
        Intrinsics.checkNotNullExpressionValue((Object)instanceData, (String)"createInstance(...)");
        this.wheel = (ModelData)instanceData;
        this.lastAngle = Float.NaN;
        this.animate(blockEntity.getAngle());
    }

    public void beginFrame() {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        float speed = ((GyroBlockEntity)this.blockEntity).getVisualSpeed().getValue(partialTicks) * (float)3 / 10.0f;
        float angle = ((GyroBlockEntity)this.blockEntity).getAngle() + speed * partialTicks;
        if ((double)Math.abs(angle - this.lastAngle) < 0.001) {
            return;
        }
        this.animate(angle);
        this.lastAngle = angle;
    }

    private final void animate(float angle) {
        PoseStack ms = new PoseStack();
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        msr.translate((Vec3i)this.getInstancePosition());
        ((TransformStack)((TransformStack)msr.centre()).rotate(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis), AngleHelper.rad((double)angle))).unCentre();
        this.wheel.setTransform(ms);
    }

    public void update() {
        this.updateRotation(this.shaft);
    }

    public void updateLight() {
        FlatLit[] flatLitArray = new FlatLit[]{this.shaft, this.wheel};
        this.relight(this.pos, flatLitArray);
    }

    protected void remove() {
        this.shaft.delete();
        this.wheel.delete();
    }
}

