/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.phys.gyro;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a5\u0010\t\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;", "physShip", "Lorg/joml/Vector3dc;", "omega", "forces", "", "strength", "targetVector", "", "gyroStabilizer", "(Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;Lorg/joml/Vector3dc;Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;DLorg/joml/Vector3dc;)V", "clockwork"})
public final class GyroStabilizerKt {
    public static final void gyroStabilizer(@NotNull PhysShipImpl physShip, @NotNull Vector3dc omega, @NotNull PhysShipImpl forces, double strength, @NotNull Vector3dc targetVector) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)omega, (String)"omega");
        Intrinsics.checkNotNullParameter((Object)forces, (String)"forces");
        Intrinsics.checkNotNullParameter((Object)targetVector, (String)"targetVector");
        Vector3d shipUp = new Vector3d(0.0, 1.0, 0.0);
        Vector3dc worldUp = targetVector;
        physShip.getPoseVel().getRot().transform(shipUp);
        double angleBetween = shipUp.angle(worldUp);
        Vector3d idealAngularAcceleration = new Vector3d();
        if (angleBetween > 0.01) {
            Vector3d stabilizationRotationAxisNormalized = shipUp.cross(worldUp, new Vector3d()).normalize();
            idealAngularAcceleration.add((Vector3dc)stabilizationRotationAxisNormalized.mul(angleBetween, stabilizationRotationAxisNormalized));
        }
        idealAngularAcceleration.sub(omega.x(), omega.y(), omega.z());
        Vector3d stabilizationTorque = physShip.getPoseVel().getRot().transform(physShip.getInertia().getMomentOfInertiaTensor().transform(physShip.getPoseVel().getRot().transformInverse(idealAngularAcceleration)));
        stabilizationTorque.mul(strength);
        Intrinsics.checkNotNull((Object)stabilizationTorque);
        forces.applyInvariantTorque((Vector3dc)stabilizationTorque);
    }
}

