/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.propeller;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.valkyrienskies.clockwork.content.contraptions.propeller.PropellerBearingBlock;
import org.valkyrienskies.clockwork.content.contraptions.propeller.PropellerBearingBlockEntity;
import org.valkyrienskies.clockwork.content.contraptions.propeller.contraption.PropellerContraption;
import org.valkyrienskies.clockwork.content.contraptions.propeller.data.PropCreateData;
import org.valkyrienskies.clockwork.content.contraptions.propeller.data.PropUpdateData;
import org.valkyrienskies.clockwork.content.forces.PropellerController;
import org.valkyrienskies.clockwork.util.ClockworkConstants;
import org.valkyrienskies.clockwork.util.EaseHelper;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b/\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u00ab\u0001B*\u0012\f\u0010\u00a5\u0001\u001a\u0007\u0012\u0002\b\u00030\u00a4\u0001\u0012\u0007\u0010\u00a6\u0001\u001a\u00020\u0014\u0012\b\u0010\u00a8\u0001\u001a\u00030\u00a7\u0001\u00a2\u0006\u0006\b\u00a9\u0001\u0010\u00aa\u0001J\u001d\u0010\u0007\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\nJ\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J%\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001f\u0010\nJ\r\u0010!\u001a\u00020 \u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020 2\u0006\u0010\r\u001a\u00020#H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020 H\u0016\u00a2\u0006\u0004\b&\u0010\"J\u000f\u0010'\u001a\u00020 H\u0016\u00a2\u0006\u0004\b'\u0010\"J\u000f\u0010(\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b(\u0010\nJ\u000f\u0010)\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b)\u0010\nJ\u000f\u0010*\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b*\u0010\nJ\u000f\u0010+\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b+\u0010\nJ\u000f\u0010,\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b,\u0010\nJ\u000f\u0010-\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b-\u0010\nJ\u0017\u0010/\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b/\u00100J\u000f\u00101\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b1\u0010\nJ\u001f\u00105\u001a\u00020\u00062\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u00020 H\u0014\u00a2\u0006\u0004\b5\u00106J\u000f\u00107\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b7\u0010\nJ\u000f\u00108\u001a\u00020 H\u0002\u00a2\u0006\u0004\b8\u0010\"J\u0017\u0010:\u001a\u00020\u00062\u0006\u00109\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b:\u00100J\u0017\u0010=\u001a\u00020\u00062\u0006\u0010<\u001a\u00020;H\u0004\u00a2\u0006\u0004\b=\u0010>J\r\u0010?\u001a\u00020\u0006\u00a2\u0006\u0004\b?\u0010\nJ\u000f\u0010@\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b@\u0010\nJ\u001f\u0010A\u001a\u00020\u00062\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u00020 H\u0016\u00a2\u0006\u0004\bA\u00106R\"\u0010B\u001a\u00020\u00198\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010C\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u0011\u0010I\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0012R\"\u0010J\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bJ\u0010C\u001a\u0004\bK\u0010E\"\u0004\bL\u0010GR\"\u0010M\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010N\u001a\u0004\bO\u0010\"\"\u0004\bP\u0010QR\"\u0010R\u001a\u00020\u00108\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bR\u0010S\u001a\u0004\bT\u0010\u0012\"\u0004\bU\u00100R\"\u0010V\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bV\u0010C\u001a\u0004\bW\u0010E\"\u0004\bX\u0010GR\u0011\u0010[\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\bY\u0010ZR\"\u0010\\\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\\\u0010S\u001a\u0004\b]\u0010\u0012\"\u0004\b^\u00100R\"\u0010_\u001a\u00020\u00198\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b_\u0010C\u001a\u0004\b`\u0010E\"\u0004\ba\u0010GR$\u0010c\u001a\u00020 2\u0006\u0010b\u001a\u00020 8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bc\u0010N\u001a\u0004\bc\u0010\"R$\u0010e\u001a\u0004\u0018\u00010d8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\be\u0010f\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR\"\u0010k\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bk\u0010C\u001a\u0004\bl\u0010E\"\u0004\bm\u0010GR$\u0010n\u001a\u0004\u0018\u00010\f8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bn\u0010o\u001a\u0004\bp\u0010q\"\u0004\br\u0010\u000fR*\u0010u\u001a\n\u0012\u0004\u0012\u00020t\u0018\u00010s8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bu\u0010v\u001a\u0004\bw\u0010x\"\u0004\by\u0010zR\"\u0010{\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b{\u0010S\u001a\u0004\b|\u0010\u0012\"\u0004\b}\u00100R\u0018\u0010~\u001a\u0004\u0018\u00010\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b~\u0010\u007fR\u0016\u0010\u0080\u0001\u001a\u00020\u00108\u0002X\u0082D\u00a2\u0006\u0007\n\u0005\b\u0080\u0001\u0010SR\u0016\u0010\u0081\u0001\u001a\u00020\u00108\u0002X\u0082D\u00a2\u0006\u0007\n\u0005\b\u0081\u0001\u0010SR\u0016\u0010\u0082\u0001\u001a\u00020\u00108\u0002X\u0082D\u00a2\u0006\u0007\n\u0005\b\u0082\u0001\u0010SR\u0016\u0010\u0083\u0001\u001a\u00020\u00108\u0002X\u0082D\u00a2\u0006\u0007\n\u0005\b\u0083\u0001\u0010SR\u0018\u0010\u0084\u0001\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0084\u0001\u0010SR\u0014\u0010.\u001a\u00020\u00108\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b.\u0010SR&\u0010\u0085\u0001\u001a\u00020\u00108\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0015\n\u0005\b\u0085\u0001\u0010S\u001a\u0005\b\u0086\u0001\u0010\u0012\"\u0005\b\u0087\u0001\u00100R&\u0010\u0088\u0001\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0088\u0001\u0010S\u001a\u0005\b\u0089\u0001\u0010\u0012\"\u0005\b\u008a\u0001\u00100R&\u0010\u008b\u0001\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u008b\u0001\u0010N\u001a\u0005\b\u008c\u0001\u0010\"\"\u0005\b\u008d\u0001\u0010QR.\u0010\u008e\u0001\u001a\b\u0012\u0004\u0012\u00020\u00140\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0006\b\u008e\u0001\u0010\u008f\u0001\u001a\u0006\b\u0090\u0001\u0010\u0091\u0001\"\u0005\b\u0092\u0001\u0010\bR%\u0010\u0093\u0001\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0014\n\u0005\b\u0093\u0001\u0010C\u001a\u0004\b\u001f\u0010E\"\u0005\b\u0094\u0001\u0010GR&\u0010\u0095\u0001\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0095\u0001\u0010N\u001a\u0005\b\u0096\u0001\u0010\"\"\u0005\b\u0097\u0001\u0010QR&\u0010\u0098\u0001\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0098\u0001\u0010N\u001a\u0005\b\u0099\u0001\u0010\"\"\u0005\b\u009a\u0001\u0010QR&\u0010\u009b\u0001\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u009b\u0001\u0010N\u001a\u0005\b\u009c\u0001\u0010\"\"\u0005\b\u009d\u0001\u0010QR&\u0010\u009e\u0001\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u009e\u0001\u0010S\u001a\u0005\b\u009f\u0001\u0010\u0012\"\u0005\b\u00a0\u0001\u00100R&\u0010\u00a1\u0001\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u00a1\u0001\u0010N\u001a\u0005\b\u00a2\u0001\u0010\"\"\u0005\b\u00a3\u0001\u0010Q\u00a8\u0006\u00ac\u0001"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "Lcom/simibubi/create/content/contraptions/bearing/IBearingBlockEntity;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "applyRotation", "()V", "assemble", "Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "contraption", "attach", "(Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;)V", "", "calculateStressApplied", "()F", "disassemble", "Lnet/minecraft/core/BlockPos;", "getBlockPosition", "()Lnet/minecraft/core/BlockPos;", "partialTicks", "te", "", "ordinal", "getCornerHorizontalOffset", "(FLorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity;I)F", "getInterpolatedAngle", "(F)F", "getSails", "", "handleOverStressed", "()Z", "Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;", "isAttachedTo", "(Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;)Z", "isValid", "isWoodenTop", "lazyTick", "modSlowdownSpeed", "modSpeed", "modSpinupSpeed", "onOrientationChanged", "onRotspeedChanged", "prevSpeed", "onSpeedChanged", "(F)V", "onStall", "Lnet/minecraft/nbt/CompoundTag;", "compound", "clientPacket", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "remove", "rotSpeedChanged", "forcedAngle", "setAngle", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlock$Direction;", "direction", "setBlockDirection", "(Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlock$Direction;)V", "shutDown", "tick", "write", "airCurrentUpdateCooldown", "I", "getAirCurrentUpdateCooldown", "()I", "setAirCurrentUpdateCooldown", "(I)V", "getAngularSpeed", "angularSpeed", "assembleCooldown", "getAssembleCooldown", "setAssembleCooldown", "assembleNextTick", "Z", "getAssembleNextTick", "setAssembleNextTick", "(Z)V", "clientAngleDiff", "F", "getClientAngleDiff", "setClientAngleDiff", "countDown", "getCountDown", "setCountDown", "getDirectonFromBlock", "()Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlock$Direction;", "directonFromBlock", "disassembling", "getDisassembling", "setDisassembling", "entitySearchCooldown", "getEntitySearchCooldown", "setEntitySearchCooldown", "<set-?>", "isInverted", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "lastException", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "getLastException", "()Lcom/simibubi/create/content/contraptions/AssemblyException;", "setLastException", "(Lcom/simibubi/create/content/contraptions/AssemblyException;)V", "moddingSpeed", "getModdingSpeed", "setModdingSpeed", "movedContraption", "Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "getMovedContraption", "()Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "setMovedContraption", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity$RotationDirection;", "movementDirection", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "getMovementDirection", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "setMovementDirection", "(Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;)V", "oldRotspeed", "getOldRotspeed", "setOldRotspeed", "physPropId", "Ljava/lang/Integer;", "pistonsA", "pistonsB", "pistonsC", "pistonsD", "prevAngle", "realAngle", "getRealAngle", "setRealAngle", "rotspeed", "getRotspeed", "setRotspeed", "running", "getRunning", "setRunning", "sailPositions", "Ljava/util/List;", "getSailPositions", "()Ljava/util/List;", "setSailPositions", "sails", "setSails", "slowingDown", "getSlowingDown", "setSlowingDown", "speedChanged", "getSpeedChanged", "setSpeedChanged", "spinningUp", "getSpinningUp", "setSpinningUp", "spinup", "getSpinup", "setSpinup", "wasOverStressed", "getWasOverStressed", "setWasOverStressed", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "RotationDirection", "clockwork"})
@SourceDebugExtension(value={"SMAP\nPropellerBearingBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropellerBearingBlockEntity.kt\norg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,521:1\n1#2:522\n*E\n"})
public final class PropellerBearingBlockEntity
extends KineticBlockEntity
implements IBearingBlockEntity {
    @NotNull
    private List<BlockPos> sailPositions;
    private int airCurrentUpdateCooldown;
    private int entitySearchCooldown;
    private boolean speedChanged;
    private float rotspeed;
    private float oldRotspeed;
    private int assembleCooldown;
    private boolean assembleNextTick;
    private int sails;
    private int moddingSpeed;
    private boolean slowingDown;
    private float disassembling;
    private int countDown;
    private float spinup;
    private boolean spinningUp;
    private float realAngle;
    private boolean running;
    private boolean wasOverStressed;
    private float clientAngleDiff;
    @Nullable
    private AssemblyException lastException;
    @Nullable
    private ControlledContraptionEntity movedContraption;
    private float prevAngle;
    private final float prevSpeed;
    @Nullable
    private ScrollOptionBehaviour<RotationDirection> movementDirection;
    private boolean isInverted;
    @Nullable
    private Integer physPropId;
    private final float pistonsA;
    private final float pistonsB;
    private final float pistonsC;
    private final float pistonsD;

    public PropellerBearingBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.sailPositions = new ArrayList();
        this.countDown = 200;
        this.pistonsB = 0.09375f;
        this.pistonsC = 0.1875f;
        this.pistonsD = 0.28125f;
    }

    @NotNull
    public final List<BlockPos> getSailPositions() {
        return this.sailPositions;
    }

    public final void setSailPositions(@NotNull List<BlockPos> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.sailPositions = list;
    }

    protected final int getAirCurrentUpdateCooldown() {
        return this.airCurrentUpdateCooldown;
    }

    protected final void setAirCurrentUpdateCooldown(int n) {
        this.airCurrentUpdateCooldown = n;
    }

    protected final int getEntitySearchCooldown() {
        return this.entitySearchCooldown;
    }

    protected final void setEntitySearchCooldown(int n) {
        this.entitySearchCooldown = n;
    }

    public final boolean getSpeedChanged() {
        return this.speedChanged;
    }

    public final void setSpeedChanged(boolean bl) {
        this.speedChanged = bl;
    }

    public final float getRotspeed() {
        return this.rotspeed;
    }

    public final void setRotspeed(float f) {
        this.rotspeed = f;
    }

    public final float getOldRotspeed() {
        return this.oldRotspeed;
    }

    public final void setOldRotspeed(float f) {
        this.oldRotspeed = f;
    }

    public final int getAssembleCooldown() {
        return this.assembleCooldown;
    }

    public final void setAssembleCooldown(int n) {
        this.assembleCooldown = n;
    }

    public final boolean getAssembleNextTick() {
        return this.assembleNextTick;
    }

    public final void setAssembleNextTick(boolean bl) {
        this.assembleNextTick = bl;
    }

    public final int getSails() {
        return this.sails;
    }

    public final void setSails(int n) {
        this.sails = n;
    }

    public final int getModdingSpeed() {
        return this.moddingSpeed;
    }

    public final void setModdingSpeed(int n) {
        this.moddingSpeed = n;
    }

    public final boolean getSlowingDown() {
        return this.slowingDown;
    }

    public final void setSlowingDown(boolean bl) {
        this.slowingDown = bl;
    }

    public final float getDisassembling() {
        return this.disassembling;
    }

    public final void setDisassembling(float f) {
        this.disassembling = f;
    }

    public final int getCountDown() {
        return this.countDown;
    }

    public final void setCountDown(int n) {
        this.countDown = n;
    }

    public final float getSpinup() {
        return this.spinup;
    }

    public final void setSpinup(float f) {
        this.spinup = f;
    }

    public final boolean getSpinningUp() {
        return this.spinningUp;
    }

    public final void setSpinningUp(boolean bl) {
        this.spinningUp = bl;
    }

    protected final float getRealAngle() {
        return this.realAngle;
    }

    protected final void setRealAngle(float f) {
        this.realAngle = f;
    }

    public final boolean getRunning() {
        return this.running;
    }

    public final void setRunning(boolean bl) {
        this.running = bl;
    }

    public final boolean getWasOverStressed() {
        return this.wasOverStressed;
    }

    public final void setWasOverStressed(boolean bl) {
        this.wasOverStressed = bl;
    }

    protected final float getClientAngleDiff() {
        return this.clientAngleDiff;
    }

    protected final void setClientAngleDiff(float f) {
        this.clientAngleDiff = f;
    }

    @Nullable
    protected final AssemblyException getLastException() {
        return this.lastException;
    }

    protected final void setLastException(@Nullable AssemblyException assemblyException) {
        this.lastException = assemblyException;
    }

    @Nullable
    protected final ControlledContraptionEntity getMovedContraption() {
        return this.movedContraption;
    }

    protected final void setMovedContraption(@Nullable ControlledContraptionEntity controlledContraptionEntity) {
        this.movedContraption = controlledContraptionEntity;
    }

    @Nullable
    protected final ScrollOptionBehaviour<RotationDirection> getMovementDirection() {
        return this.movementDirection;
    }

    protected final void setMovementDirection(@Nullable ScrollOptionBehaviour<RotationDirection> scrollOptionBehaviour) {
        this.movementDirection = scrollOptionBehaviour;
    }

    public final boolean isInverted() {
        return this.isInverted;
    }

    public final float getCornerHorizontalOffset(float partialTicks, @NotNull PropellerBearingBlockEntity te, int ordinal) {
        Intrinsics.checkNotNullParameter((Object)((Object)te), (String)"te");
        if (!this.running) {
            return 0.0f;
        }
        return switch (ordinal) {
            case 1 -> 0.1875f + (float)Math.sin(EaseHelper.INSTANCE.easeInOutSine(this.pistonsA)) / 16.0f;
            case 2 -> 0.1875f + (float)Math.sin(EaseHelper.INSTANCE.easeInOutSine(this.pistonsB)) / 16.0f;
            case 3 -> 0.1875f + (float)Math.sin(EaseHelper.INSTANCE.easeInOutSine(this.pistonsC)) / 16.0f;
            default -> 0.1875f + (float)Math.sin(EaseHelper.INSTANCE.easeInOutSine(this.pistonsD)) / 16.0f;
        };
    }

    public float getInterpolatedAngle(float partialTicks) {
        float partialTicks2;
        block6: {
            block5: {
                partialTicks2 = partialTicks;
                if (this.isVirtual()) {
                    return Mth.m_14179_((float)(partialTicks2 + 0.5f), (float)this.prevAngle, (float)this.realAngle);
                }
                if (this.movedContraption == null) break block5;
                ControlledContraptionEntity controlledContraptionEntity = this.movedContraption;
                Intrinsics.checkNotNull((Object)controlledContraptionEntity);
                if (!controlledContraptionEntity.isStalled() && this.running) break block6;
            }
            partialTicks2 = 0.0f;
        }
        if (this.overStressed) {
            return 0.0f;
        }
        return Mth.m_14179_((float)partialTicks2, (float)this.realAngle, (float)(this.realAngle + this.getAngularSpeed()));
    }

    public final float getAngularSpeed() {
        float angspeed = KineticBlockEntity.convertToAngular((float)this.rotspeed) * 1.25f;
        if (this.rotspeed == 0.0f) {
            angspeed = 0.0f;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            angspeed *= ServerSpeedProvider.get();
            angspeed += this.clientAngleDiff / 3.0f;
        }
        return angspeed;
    }

    public final boolean handleOverStressed() {
        if (this.overStressed) {
            this.wasOverStressed = true;
        }
        if (this.wasOverStressed) {
            int n = this.countDown;
            this.countDown = n + -1;
            if (this.countDown <= 0) {
                this.wasOverStressed = false;
                this.countDown = 60;
            }
        }
        return this.wasOverStressed;
    }

    public void tick() {
        boolean server;
        block23: {
            block22: {
                super.tick();
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                boolean bl = server = !level.f_46443_ || this.isVirtual();
                if (this.rotSpeedChanged()) {
                    this.sendData();
                }
                this.oldRotspeed = this.rotspeed;
                if (this.spinningUp) {
                    this.modSpinupSpeed();
                } else if (this.slowingDown) {
                    this.modSlowdownSpeed();
                } else {
                    this.modSpeed();
                }
                if (this.overStressed) {
                    // empty if block
                }
                if (this.rotspeed < 0.0f) {
                    this.setBlockDirection(PropellerBearingBlock.Direction.PULL);
                } else {
                    this.setBlockDirection(PropellerBearingBlock.Direction.PUSH);
                }
                if (this.speedChanged) {
                    this.onSpeedChanged(this.prevSpeed);
                    this.onRotspeedChanged();
                    this.speedChanged = false;
                }
                if (this.assembleCooldown > 0) {
                    int n = this.assembleCooldown;
                    this.assembleCooldown = n + -1;
                }
                this.prevAngle = this.realAngle;
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                if (level2.f_46443_) {
                    this.clientAngleDiff /= 2.0f;
                }
                Level level3 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level3);
                if (!level3.f_46443_ && this.assembleNextTick) {
                    this.assembleCooldown = 40;
                    this.assembleNextTick = false;
                    if (!this.running) {
                        this.assemble();
                    }
                }
                if (this.handleOverStressed()) {
                    return;
                }
                if (!this.running) {
                    return;
                }
                if (this.movedContraption == null) break block22;
                ControlledContraptionEntity controlledContraptionEntity = this.movedContraption;
                Intrinsics.checkNotNull((Object)controlledContraptionEntity);
                if (controlledContraptionEntity.isStalled()) break block23;
            }
            if (!this.overStressed) {
                float angularSpeed = this.getAngularSpeed();
                float newAngle = this.realAngle + angularSpeed;
                this.realAngle = newAngle % (float)360;
            }
        }
        this.applyRotation();
        if (this.physPropId != null && server) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos));
            if (ship != null) {
                int dumbFix = 1;
                Direction direction = (Direction)this.m_58900_().m_61143_((Property)BearingBlock.FACING);
                if (direction == Direction.WEST || direction == Direction.NORTH || direction == Direction.DOWN) {
                    dumbFix = -dumbFix;
                }
                PropUpdateData data = new PropUpdateData((double)dumbFix * (double)this.getAngularSpeed(), this.realAngle, this.isInverted, this.overStressed);
                PropellerController propellerController = PropellerController.Companion.getOrCreate((ServerShip)ship);
                Intrinsics.checkNotNull((Object)propellerController);
                Integer n = this.physPropId;
                Intrinsics.checkNotNull((Object)n);
                propellerController.updatePropeller(n, data);
            }
        }
    }

    private final void modSpeed() {
        if (this.movedContraption == null) {
            return;
        }
        if (this.rotspeed == this.speed) {
            return;
        }
        float diff = this.speed - this.rotspeed;
        this.rotspeed += Mth.m_14036_((float)(diff / (float)10), (float)-32.0f, (float)32.0f);
    }

    private final void modSlowdownSpeed() {
        float f = this.disassembling;
        this.disassembling = f + -1.0f;
        if (this.disassembling <= 0.0f) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (!level.f_46443_) {
                this.disassemble();
            }
            this.slowingDown = false;
            this.disassembling = 0.0f;
            return;
        }
        float stoppingPoint = this.realAngle + this.rotspeed * this.disassembling * 0.5f;
        float optimalStoppingPoint = 90.0f * (float)Math.round(stoppingPoint / 90.0f);
        float Q = (optimalStoppingPoint - stoppingPoint) / this.disassembling;
        this.rotspeed = (this.rotspeed + 6.0f * Q / this.disassembling) * (1.0f - 1.0f / this.disassembling);
    }

    private final void modSpinupSpeed() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        float f = this.spinup;
        this.spinup = f + -1.0f;
        if (Math.abs(this.rotspeed) >= Math.abs(this.speed)) {
            this.spinningUp = false;
            if (Math.abs(this.rotspeed) > Math.abs(this.speed)) {
                this.rotspeed = this.speed;
            }
            return;
        }
        float startingPoint = this.realAngle + this.speed * this.spinup * 0.5f;
        float Q = startingPoint / this.spinup;
        this.rotspeed = (this.rotspeed + 6.0f * Q / this.spinup) * (1.0f - 1.0f / this.spinup);
    }

    public float calculateStressApplied() {
        if (this.running && this.movedContraption != null) {
            if (this.sails == 0) {
                this.getSails();
            }
            this.sails = this.sailPositions.size();
            return (float)this.sails * 2.0f;
        }
        return 0.0f;
    }

    protected final void applyRotation() {
        if (this.movedContraption == null) {
            return;
        }
        ControlledContraptionEntity controlledContraptionEntity = this.movedContraption;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity);
        controlledContraptionEntity.setAngle(this.realAngle);
        BlockState blockState = this.m_58900_();
        if (blockState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            ControlledContraptionEntity controlledContraptionEntity2 = this.movedContraption;
            Intrinsics.checkNotNull((Object)controlledContraptionEntity2);
            controlledContraptionEntity2.setRotationAxis(((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_());
        }
    }

    public void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.m_128350_(ClockworkConstants.Nbt.INSTANCE.getROT_SPEED(), this.rotspeed);
        compound.m_128379_(ClockworkConstants.Nbt.INSTANCE.getRUNNING(), this.running);
        compound.m_128350_(ClockworkConstants.Nbt.INSTANCE.getANGLE(), this.realAngle);
        compound.m_128379_(ClockworkConstants.Nbt.INSTANCE.getINVERTED(), this.isInverted);
        if (this.physPropId != null) {
            String string = ClockworkConstants.Nbt.INSTANCE.getID();
            Integer n = this.physPropId;
            Intrinsics.checkNotNull((Object)n);
            compound.m_128405_(string, n.intValue());
        }
        AssemblyException.write((CompoundTag)compound, (AssemblyException)this.lastException);
        super.write(compound, clientPacket);
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        float angleBefore = this.realAngle;
        this.rotspeed = compound.m_128457_(ClockworkConstants.Nbt.INSTANCE.getROT_SPEED());
        this.running = compound.m_128471_(ClockworkConstants.Nbt.INSTANCE.getRUNNING());
        this.realAngle = compound.m_128457_(ClockworkConstants.Nbt.INSTANCE.getANGLE());
        this.isInverted = compound.m_128471_(ClockworkConstants.Nbt.INSTANCE.getINVERTED());
        this.lastException = AssemblyException.read((CompoundTag)compound);
        if (compound.m_128441_(ClockworkConstants.Nbt.INSTANCE.getID())) {
            this.physPropId = compound.m_128451_(ClockworkConstants.Nbt.INSTANCE.getID());
        }
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.running) {
            this.clientAngleDiff = AngleHelper.getShortestAngleDiff((double)angleBefore, (double)this.realAngle);
            this.realAngle = angleBefore;
        } else {
            this.movedContraption = null;
        }
    }

    public void attach(@NotNull ControlledContraptionEntity contraption) {
        Intrinsics.checkNotNullParameter((Object)contraption, (String)"contraption");
        BlockState blockState = this.m_58900_();
        if (!(contraption.getContraption() instanceof PropellerContraption)) {
            return;
        }
        if (!blockState.m_61138_((Property)BearingBlock.FACING)) {
            return;
        }
        this.movedContraption = contraption;
        this.m_6596_();
        BlockPos anchor = this.f_58858_.m_121945_((Direction)blockState.m_61143_((Property)BearingBlock.FACING));
        ControlledContraptionEntity controlledContraptionEntity = this.movedContraption;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity);
        controlledContraptionEntity.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.running = true;
            this.sendData();
        }
    }

    public boolean isWoodenTop() {
        return false;
    }

    @NotNull
    public final PropellerBearingBlock.Direction getDirectonFromBlock() {
        BlockState blockState = this.m_58900_();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        return PropellerBearingBlock.Companion.getDirectionof(blockState);
    }

    protected final void setBlockDirection(@NotNull PropellerBearingBlock.Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        PropellerBearingBlock.Direction inBlockState = this.getDirectonFromBlock();
        if (inBlockState == direction) {
            return;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        level.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)PropellerBearingBlock.Companion.getDIRECTION(), (Comparable)((Object)direction)));
        this.notifyUpdate();
    }

    public final void getSails() {
        this.sailPositions = new ArrayList();
        if (this.movedContraption != null) {
            ControlledContraptionEntity controlledContraptionEntity = this.movedContraption;
            Intrinsics.checkNotNull((Object)controlledContraptionEntity);
            Map Blocks2 = controlledContraptionEntity.getContraption().getBlocks();
            Intrinsics.checkNotNull((Object)Blocks2);
            for (Map.Entry entry : Blocks2.entrySet()) {
                BlockPos key = (BlockPos)entry.getKey();
                StructureTemplate.StructureBlockInfo value = (StructureTemplate.StructureBlockInfo)entry.getValue();
                if (!AllTags.AllBlockTags.WINDMILL_SAILS.matches(value.f_74676_())) continue;
                Intrinsics.checkNotNull((Object)key);
                this.sailPositions.add(key);
            }
        }
    }

    public void setAngle(float forcedAngle) {
        this.realAngle = forcedAngle;
    }

    public void remove() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.disassemble();
        }
        super.remove();
    }

    private final void assemble() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!(level.m_8055_(this.f_58858_).m_60734_() instanceof PropellerBearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        PropellerContraption contraption = null;
        try {
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2);
            BlockPos blockPos = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
            Intrinsics.checkNotNull((Object)direction);
            PropellerContraption propellerContraption = PropellerContraption.Companion.assembleProp(level2, blockPos, direction);
            Intrinsics.checkNotNull((Object)((Object)propellerContraption));
            contraption = propellerContraption;
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        this.speedChanged = this.rotSpeedChanged();
        if (contraption.getBlocks().isEmpty()) {
            return;
        }
        BlockPos anchor = this.f_58858_.m_121945_(direction);
        contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
        ControlledContraptionEntity controlledContraptionEntity = this.movedContraption = ControlledContraptionEntity.create((Level)this.f_58857_, (IControlContraption)((IControlContraption)this), (Contraption)contraption);
        Intrinsics.checkNotNull((Object)controlledContraptionEntity);
        controlledContraptionEntity.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        ControlledContraptionEntity controlledContraptionEntity2 = this.movedContraption;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity2);
        controlledContraptionEntity2.setRotationAxis(direction.m_122434_());
        ControlledContraptionEntity controlledContraptionEntity3 = this.movedContraption;
        if (controlledContraptionEntity3 != null) {
            ControlledContraptionEntity it = controlledContraptionEntity3;
            boolean bl = false;
            Level level3 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level3);
            level3.m_7967_((Entity)it);
        }
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
        this.running = true;
        this.realAngle = 0.0f;
        this.rotspeed = 0.0f;
        this.spinningUp = true;
        this.spinup = (int)Math.abs(this.speed);
        this.getSails();
        List<Vector3i> sailVecs2 = this.sailPositions.stream().map(arg_0 -> PropellerBearingBlockEntity.assemble$lambda$1(assemble.sailVecs.1.INSTANCE, arg_0)).toList();
        Vec3i vec3i = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        Vector3dc axis = (Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)vec3i);
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Vector3dc vecPos = (Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos));
        double d = this.realAngle;
        double d2 = this.getAngularSpeed();
        Intrinsics.checkNotNull(sailVecs2);
        PropCreateData data = new PropCreateData(vecPos, axis, d, d2, sailVecs2, this.isInverted, this.overStressed);
        Level level4 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level4);
        if (!level4.f_46443_) {
            Level level5 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level5, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level5;
            BlockPos blockPos2 = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
            LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos2));
            if (ship != null) {
                PropellerController propellerController = PropellerController.Companion.getOrCreate((ServerShip)ship);
                Intrinsics.checkNotNull((Object)propellerController);
                this.physPropId = propellerController.addPropeller(data);
            }
        }
        this.sendData();
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        super.addBehaviours(behaviours);
        this.movementDirection = new ScrollOptionBehaviour(RotationDirection.class, (Component)Lang.translateDirect((String)"contraptions.Propeller.movement_direction", (Object[])new Object[0]), (SmartBlockEntity)this, this.getMovementModeSlot());
        ScrollOptionBehaviour<RotationDirection> scrollOptionBehaviour = this.movementDirection;
        Intrinsics.checkNotNull(scrollOptionBehaviour);
        scrollOptionBehaviour.requiresWrench();
        ScrollOptionBehaviour<RotationDirection> scrollOptionBehaviour2 = this.movementDirection;
        Intrinsics.checkNotNull(scrollOptionBehaviour2);
        scrollOptionBehaviour2.withCallback(arg_0 -> PropellerBearingBlockEntity.addBehaviours$lambda$2(this, arg_0));
        ScrollOptionBehaviour<RotationDirection> scrollOptionBehaviour3 = this.movementDirection;
        Intrinsics.checkNotNull(scrollOptionBehaviour3);
        behaviours.add((BlockEntityBehaviour)scrollOptionBehaviour3);
    }

    private final void onOrientationChanged() {
        this.isInverted = !this.isInverted;
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.running && this.movedContraption != null) {
            this.sendData();
        }
    }

    public final void shutDown() {
        if (this.assembleCooldown > 0) {
            return;
        }
        this.slowingDown = true;
        this.disassembling = Math.abs(this.rotspeed);
        this.spinningUp = false;
        this.spinup = 0.0f;
    }

    private final void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.rotspeed = 0.0f;
        this.realAngle = 0.0f;
        this.slowingDown = false;
        this.disassembling = 0.0f;
        if (this.movedContraption != null) {
            ControlledContraptionEntity controlledContraptionEntity = this.movedContraption;
            Intrinsics.checkNotNull((Object)controlledContraptionEntity);
            controlledContraptionEntity.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
        }
        this.movedContraption = null;
        this.running = false;
        if (this.physPropId != null) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (!level.f_46443_) {
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level2;
                BlockPos blockPos = this.m_58899_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos));
                if (ship != null) {
                    PropellerController propellerController = PropellerController.Companion.getOrCreate((ServerShip)ship);
                    Intrinsics.checkNotNull((Object)propellerController);
                    Integer n = this.physPropId;
                    Intrinsics.checkNotNull((Object)n);
                    propellerController.removePropeller(n);
                }
            }
        }
        this.sendData();
    }

    private final boolean rotSpeedChanged() {
        return !(this.rotspeed == this.oldRotspeed);
    }

    private final void onRotspeedChanged() {
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.detachKinetics();
    }

    public boolean isAttachedTo(@NotNull AbstractContraptionEntity contraption) {
        Intrinsics.checkNotNullParameter((Object)contraption, (String)"contraption");
        return !(contraption.getContraption() instanceof PropellerContraption) ? false : this.movedContraption == contraption;
    }

    public void onStall() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.sendData();
        }
    }

    public boolean isValid() {
        return !this.m_58901_();
    }

    @NotNull
    public BlockPos getBlockPosition() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        return blockPos;
    }

    private static final Vector3i assemble$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Vector3i)$tmp0.invoke(p0);
    }

    private static final void addBehaviours$lambda$2(PropellerBearingBlockEntity this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onOrientationChanged();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0011\b\u0002\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fj\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity$RotationDirection;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/INamedIconOptions;", "Lcom/simibubi/create/foundation/gui/AllIcons;", "getIcon", "()Lcom/simibubi/create/foundation/gui/AllIcons;", "", "getTranslationKey", "()Ljava/lang/String;", "icon", "Lcom/simibubi/create/foundation/gui/AllIcons;", "translationKey", "Ljava/lang/String;", "<init>", "(Ljava/lang/String;ILcom/simibubi/create/foundation/gui/AllIcons;)V", "NORMAL", "INVERTED", "clockwork"})
    public static final class RotationDirection
    extends Enum<RotationDirection>
    implements INamedIconOptions {
        @NotNull
        private final AllIcons icon;
        @NotNull
        private final String translationKey;
        public static final /* enum */ RotationDirection NORMAL;
        public static final /* enum */ RotationDirection INVERTED;
        private static final /* synthetic */ RotationDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private RotationDirection(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "generic." + Lang.asId((String)this.name());
        }

        @NotNull
        public AllIcons getIcon() {
            return this.icon;
        }

        @NotNull
        public String getTranslationKey() {
            return this.translationKey;
        }

        public static RotationDirection[] values() {
            return (RotationDirection[])$VALUES.clone();
        }

        public static RotationDirection valueOf(String value) {
            return Enum.valueOf(RotationDirection.class, value);
        }

        @NotNull
        public static EnumEntries<RotationDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            AllIcons allIcons = AllIcons.I_REFRESH;
            Intrinsics.checkNotNullExpressionValue((Object)allIcons, (String)"I_REFRESH");
            NORMAL = new RotationDirection(allIcons);
            AllIcons allIcons2 = AllIcons.I_ROTATE_CCW;
            Intrinsics.checkNotNullExpressionValue((Object)allIcons2, (String)"I_ROTATE_CCW");
            INVERTED = new RotationDirection(allIcons2);
            $VALUES = rotationDirectionArray = new RotationDirection[]{RotationDirection.NORMAL, RotationDirection.INVERTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

