/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.propeller;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.contraptions.propeller.PropellerBearingBlockEntity;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ?\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J?\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingRenderer;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity;", "te", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lcom/simibubi/create/foundation/render/SuperByteBuffer;", "getRotatedModel", "(Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity;Lnet/minecraft/world/level/block/state/BlockState;)Lcom/simibubi/create/foundation/render/SuperByteBuffer;", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "speed", "Lnet/minecraft/core/Direction;", "facing", "ordinal", "shakeEngine", "(Lcom/simibubi/create/foundation/render/SuperByteBuffer;FFLnet/minecraft/core/Direction;Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity;I)Lcom/simibubi/create/foundation/render/SuperByteBuffer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "clockwork"})
public final class PropellerBearingRenderer
extends KineticBlockEntityRenderer<PropellerBearingBlockEntity> {
    public PropellerBearingRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    protected void renderSafe(@NotNull PropellerBearingBlockEntity te, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)te), (String)"te");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.renderSafe((KineticBlockEntity)te, partialTicks, ms, buffer, light, overlay);
        PropellerBearingBlockEntity bearingTe = te;
        KineticBlockEntity kineticBlockEntity = te;
        BlockState blockState = te.m_58900_();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)kineticBlockEntity, (SuperByteBuffer)this.getRotatedModel(te, blockState), (PoseStack)ms, (VertexConsumer)buffer.m_6299_(RenderType.m_110451_()), (int)light);
        Comparable comparable = te.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        Direction facing = (Direction)comparable;
        PartialModel top = ClockworkPartials.INSTANCE.getPROPELLER_TOP();
        SuperByteBuffer superBuffer = CachedBufferer.partial((PartialModel)top, (BlockState)te.m_58900_());
        ms.m_85836_();
        ms.m_85837_(0.5, 0.5, 0.5);
        ms.m_252781_(new Quaternionf().rotationXYZ(0.0f, (float)Math.toRadians(-180.0), 0.0f));
        Direction ogfacing = (Direction)te.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        int disgustingFix = 1;
        Direction direction = ogfacing;
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                ms.m_252781_(Axis.f_252529_.m_252977_(270.0f));
                break;
            }
            case 2: {
                ms.m_252781_(Axis.f_252403_.m_252977_(270.0f));
                disgustingFix = -disgustingFix;
                break;
            }
            case 3: {
                ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                disgustingFix = -disgustingFix;
                break;
            }
            case 4: {
                ms.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                break;
            }
            case 5: {
                ms.m_252781_(Axis.f_252529_.m_252977_(0.0f));
                break;
            }
            case 6: {
                ms.m_252781_(Axis.f_252495_.m_252977_(180.0f));
                disgustingFix = -disgustingFix;
            }
        }
        ms.m_85837_(-0.5, -0.5, -0.5);
        SuperByteBuffer pistonTopL = CachedBufferer.partial((PartialModel)ClockworkPartials.INSTANCE.getPROPELLER_PISTON_TOP_LEFT(), (BlockState)te.m_58900_());
        SuperByteBuffer pistonTopR = CachedBufferer.partial((PartialModel)ClockworkPartials.INSTANCE.getPROPELLER_PISTON_TOP_RIGHT(), (BlockState)te.m_58900_());
        SuperByteBuffer pistonBotL = CachedBufferer.partial((PartialModel)ClockworkPartials.INSTANCE.getPROPELLER_PISTON_BOTTOM_LEFT(), (BlockState)te.m_58900_());
        SuperByteBuffer pistonBotR = CachedBufferer.partial((PartialModel)ClockworkPartials.INSTANCE.getPROPELLER_PISTON_BOTTOM_RIGHT(), (BlockState)te.m_58900_());
        float interpolatedAngle = bearingTe.getInterpolatedAngle(partialTicks - 1.0f);
        KineticBlockEntityRenderer.kineticRotationTransform((SuperByteBuffer)superBuffer, (KineticBlockEntity)te, (Direction.Axis)Direction.UP.m_122434_(), (float)((float)disgustingFix * (float)((double)(interpolatedAngle / (float)180) * Math.PI)), (int)light);
        Intrinsics.checkNotNull((Object)pistonTopL);
        this.shakeEngine(pistonTopL, te.getRotspeed(), partialTicks, facing, te, 1);
        Intrinsics.checkNotNull((Object)pistonTopR);
        this.shakeEngine(pistonTopR, te.getRotspeed(), partialTicks, facing, te, 2);
        Intrinsics.checkNotNull((Object)pistonBotL);
        this.shakeEngine(pistonBotL, te.getRotspeed(), partialTicks, facing, te, 3);
        Intrinsics.checkNotNull((Object)pistonBotR);
        this.shakeEngine(pistonBotR, te.getRotspeed(), partialTicks, facing, te, 4);
        if (facing.m_122434_().m_122479_()) {
            superBuffer.rotateCentered(Direction.UP, AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122424_())));
        }
        superBuffer.rotateCentered(Direction.UP, AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122424_())));
        pistonTopL.rotateCentered(Direction.UP, AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122424_())));
        pistonTopR.rotateCentered(Direction.UP, AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122424_())));
        pistonBotL.rotateCentered(Direction.UP, AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122424_())));
        pistonBotR.rotateCentered(Direction.UP, AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122424_())));
        pistonTopL.rotateCentered(Direction.EAST, AngleHelper.rad((double)((float)-90 - AngleHelper.verticalAngle((Direction)facing))));
        pistonTopR.rotateCentered(Direction.EAST, AngleHelper.rad((double)((float)-90 - AngleHelper.verticalAngle((Direction)facing))));
        pistonBotR.rotateCentered(Direction.EAST, AngleHelper.rad((double)((float)-90 - AngleHelper.verticalAngle((Direction)facing))));
        pistonBotL.rotateCentered(Direction.EAST, AngleHelper.rad((double)((float)-90 - AngleHelper.verticalAngle((Direction)facing))));
        pistonTopL.renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
        pistonTopR.renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
        pistonBotL.renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
        pistonBotR.renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
        superBuffer.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        ms.m_85849_();
    }

    @NotNull
    protected SuperByteBuffer getRotatedModel(@NotNull PropellerBearingBlockEntity te, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)te), (String)"te");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        SuperByteBuffer superByteBuffer = CachedBufferer.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state, (Direction)((Direction)state.m_61143_((Property)BearingBlock.FACING)).m_122424_());
        Intrinsics.checkNotNullExpressionValue((Object)superByteBuffer, (String)"partialFacing(...)");
        return superByteBuffer;
    }

    private final SuperByteBuffer shakeEngine(SuperByteBuffer buffer, float speed, float partialTicks, Direction facing, PropellerBearingBlockEntity te, int ordinal) {
        float speed2 = speed;
        speed2 = Mth.m_14036_((float)speed2, (float)-48.0f, (float)48.0f);
        int xSwitch = switch (ordinal) {
            case 1 -> 1;
            case 2 -> -1;
            case 3 -> 1;
            case 4 -> -1;
            default -> 1;
        };
        int zSwitch = switch (ordinal) {
            case 1 -> 1;
            case 2 -> 1;
            case 3 -> -1;
            case 4 -> -1;
            default -> 1;
        };
        float interpolatedHorizontalOffset = te.getCornerHorizontalOffset(AnimationTickHolder.getPartialTicks() - 1.0f, te, ordinal);
        double verticalOffset = switch (ordinal) {
            case 1 -> 0.09375;
            case 2 -> 0.09375;
            case 3 -> 0.0;
            case 4 -> 0.0;
            default -> 0.0;
        };
        Vec3 translate = switch (WhenMappings.$EnumSwitchMapping$0[facing.ordinal()]) {
            case 5 -> new Vec3((double)(interpolatedHorizontalOffset * (float)xSwitch), verticalOffset, (double)(interpolatedHorizontalOffset * (float)zSwitch));
            case 3 -> new Vec3((double)(interpolatedHorizontalOffset * (float)xSwitch), (double)(interpolatedHorizontalOffset * (float)zSwitch), verticalOffset);
            case 1 -> new Vec3((double)(interpolatedHorizontalOffset * (float)zSwitch), (double)(interpolatedHorizontalOffset * (float)xSwitch), verticalOffset);
            case 4 -> new Vec3(verticalOffset, (double)(interpolatedHorizontalOffset * (float)xSwitch), (double)(interpolatedHorizontalOffset * (float)zSwitch));
            case 2 -> new Vec3(verticalOffset, (double)(interpolatedHorizontalOffset * (float)zSwitch), (double)(interpolatedHorizontalOffset * (float)xSwitch));
            case 6 -> new Vec3((double)(interpolatedHorizontalOffset * (float)xSwitch), verticalOffset, (double)(interpolatedHorizontalOffset * (float)zSwitch));
            default -> throw new NoWhenBranchMatchedException();
        };
        buffer.translate(translate);
        return buffer;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.SOUTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

