/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities;

import com.simibubi.create.content.materials.ExperienceBlock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.content.curiosities.WanderShipControl;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.assembly.ShipAssemblyKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b(\u0010)J/\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\u0014J7\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ?\u0010$\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b$\u0010%\u00a8\u0006*"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/WanderliteOreBlock;", "Lcom/simibubi/create/content/materials/ExperienceBlock;", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/entity/player/Player;", "player", "", "attack", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/world/level/LevelAccessor;", "destroy", "(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/server/level/ServerLevel;", "blockPos", "", "isAlreadyShip", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)Z", "oldState", "movedByPiston", "onPlace", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "shipifyBlock", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V", "Lnet/minecraft/world/entity/Entity;", "entity", "stepOn", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/Entity;)V", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/InteractionResult;", "use", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "properties", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "clockwork"})
public final class WanderliteOreBlock
extends ExperienceBlock {
    public WanderliteOreBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if (level instanceof ServerLevel && !this.isAlreadyShip((ServerLevel)level, pos)) {
            this.shipifyBlock((ServerLevel)level, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6256_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (level instanceof ServerLevel && !this.isAlreadyShip((ServerLevel)level, pos)) {
            this.shipifyBlock((ServerLevel)level, pos);
        }
        super.m_6256_(state, level, pos, player);
    }

    public void m_141947_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof Player && !((Player)entity).m_20161_() && level instanceof ServerLevel && !this.isAlreadyShip((ServerLevel)level, pos)) {
            this.shipifyBlock((ServerLevel)level, pos);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public final boolean isAlreadyShip(@NotNull ServerLevel level, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        return VSGameUtilsKt.isBlockInShipyard((Level)((Level)level), (int)blockPos.m_123341_(), (int)blockPos.m_123342_(), (int)blockPos.m_123343_());
    }

    public final void shipifyBlock(@NotNull ServerLevel level, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        DenseBlockPosSet dense = new DenseBlockPosSet();
        dense.add(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        for (Direction dir : Direction.values()) {
            BlockPos dirPos = blockPos.m_121945_(dir);
            if (!level.m_8055_(dirPos).m_60713_((Block)this)) continue;
            dense.add(dirPos.m_123341_(), dirPos.m_123342_(), dirPos.m_123343_());
        }
        ServerShip connectedShip = ShipAssemblyKt.createNewShipWithBlocks((BlockPos)blockPos, (DenseBlockPosSet)dense, (ServerLevel)level);
        WanderShipControl wanderShipControl = WanderShipControl.Companion.getOrCreate(connectedShip);
        wanderShipControl.setAurics(wanderShipControl.getAurics() + dense.size());
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        ServerShip ship;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        if (level instanceof ServerLevel && (ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)((ServerLevel)level), (BlockPos)pos)) != null) {
            WanderShipControl wanderShipControl = WanderShipControl.Companion.getOrCreate(ship);
            int n = wanderShipControl.getAurics();
            wanderShipControl.setAurics(n + 1);
        }
        super.m_6807_(state, level, pos, oldState, movedByPiston);
    }

    public void m_6786_(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        ServerShip ship;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (level instanceof ServerLevel && (ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)((ServerLevel)level), (BlockPos)pos)) != null) {
            WanderShipControl wanderShipControl = WanderShipControl.Companion.getOrCreate(ship);
            int n = wanderShipControl.getAurics();
            wanderShipControl.setAurics(n + -1);
        }
        super.m_6786_(level, pos, state);
    }
}

