/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.solid.delivery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.content.logistics.solid.delivery.chute.DeliveryChuteBlockEntity;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\fj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004`\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0015\u0010 \u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\"\u0010\u001cR0\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\fj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004`\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R0\u0010%\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\fj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004`\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010$\u00a8\u0006("}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/ActiveChutes;", "", "Lnet/minecraft/core/BlockPos;", "pos", "Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/chute/DeliveryChuteBlockEntity;", "chute", "", "addChute", "(Lnet/minecraft/core/BlockPos;Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/chute/DeliveryChuteBlockEntity;)V", "Lorg/joml/Vector3dc;", "getChuteRealPos", "(Lnet/minecraft/core/BlockPos;)Lorg/joml/Vector3dc;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getChutes", "()Ljava/util/HashMap;", "", "maxDistance", "getNearestChute", "(Lnet/minecraft/core/BlockPos;D)Lnet/minecraft/core/BlockPos;", "", "id", "getNearestChuteWithId", "(Lnet/minecraft/core/BlockPos;DI)Lnet/minecraft/core/BlockPos;", "", "hasChute", "(Lnet/minecraft/core/BlockPos;)Z", "loadChute", "(Lnet/minecraft/core/BlockPos;)V", "removeChute", "Lnet/minecraft/server/level/ServerLevel;", "level", "tick", "(Lnet/minecraft/server/level/ServerLevel;)V", "unloadChute", "actives", "Ljava/util/HashMap;", "unloaded", "<init>", "()V", "clockwork"})
public final class ActiveChutes {
    @NotNull
    public static final ActiveChutes INSTANCE = new ActiveChutes();
    @NotNull
    private static final HashMap<BlockPos, DeliveryChuteBlockEntity> actives = new HashMap();
    @NotNull
    private static final HashMap<BlockPos, DeliveryChuteBlockEntity> unloaded = new HashMap();

    private ActiveChutes() {
    }

    public final void addChute(@NotNull BlockPos pos, @NotNull DeliveryChuteBlockEntity chute) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)chute, (String)"chute");
        ((Map)actives).put(pos, chute);
    }

    public final void removeChute(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        actives.remove(pos);
        unloaded.remove(pos);
    }

    private final void unloadChute(BlockPos pos) {
        Map map = unloaded;
        DeliveryChuteBlockEntity deliveryChuteBlockEntity = actives.get(pos);
        Intrinsics.checkNotNull((Object)deliveryChuteBlockEntity);
        map.put(pos, deliveryChuteBlockEntity);
        actives.remove(pos);
    }

    private final void loadChute(BlockPos pos) {
        Map map = actives;
        DeliveryChuteBlockEntity deliveryChuteBlockEntity = unloaded.get(pos);
        Intrinsics.checkNotNull((Object)deliveryChuteBlockEntity);
        map.put(pos, deliveryChuteBlockEntity);
        unloaded.remove(pos);
    }

    @NotNull
    public final HashMap<BlockPos, DeliveryChuteBlockEntity> getChutes() {
        return actives;
    }

    @Nullable
    public final BlockPos getNearestChute(@NotNull BlockPos pos, double maxDistance) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (BlockPos chute : actives.keySet()) {
            DeliveryChuteBlockEntity deliveryChuteBlockEntity = actives.get(chute);
            Intrinsics.checkNotNull((Object)deliveryChuteBlockEntity);
            Vector3dc realPos = deliveryChuteBlockEntity.getRealPos();
            BlockPos realBlockPos = new BlockPos((int)realPos.x(), (int)realPos.y(), (int)realPos.z());
            if (!realBlockPos.m_123314_((Vec3i)pos, maxDistance) || !(realPos.distance((Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)pos))) < closestDistance)) continue;
            closest = chute;
            Intrinsics.checkNotNull((Object)chute);
            closestDistance = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)chute)).distance((Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)pos)));
        }
        return closest;
    }

    @Nullable
    public final BlockPos getNearestChuteWithId(@NotNull BlockPos pos, double maxDistance, int id) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (BlockPos chute : actives.keySet()) {
            DeliveryChuteBlockEntity deliveryChuteBlockEntity = actives.get(chute);
            Intrinsics.checkNotNull((Object)deliveryChuteBlockEntity);
            Vector3dc realPos = deliveryChuteBlockEntity.getRealPos();
            BlockPos realBlockPos = new BlockPos((int)realPos.x(), (int)realPos.y(), (int)realPos.z());
            if (!realBlockPos.m_123314_((Vec3i)pos, maxDistance) || !(realPos.distance((Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)pos))) < closestDistance)) continue;
            DeliveryChuteBlockEntity deliveryChuteBlockEntity2 = actives.get(chute);
            Intrinsics.checkNotNull((Object)deliveryChuteBlockEntity2);
            if (deliveryChuteBlockEntity2.getId() != id) continue;
            closest = chute;
            Intrinsics.checkNotNull((Object)chute);
            closestDistance = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)chute)).distance((Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)pos)));
        }
        return closest;
    }

    public final boolean hasChute(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return actives.containsKey(pos) || unloaded.containsKey(pos);
    }

    @Nullable
    public final Vector3dc getChuteRealPos(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (actives.containsKey(pos)) {
            DeliveryChuteBlockEntity deliveryChuteBlockEntity = actives.get(pos);
            Intrinsics.checkNotNull((Object)deliveryChuteBlockEntity);
            return deliveryChuteBlockEntity.getRealPos();
        }
        if (unloaded.containsKey(pos)) {
            DeliveryChuteBlockEntity deliveryChuteBlockEntity = unloaded.get(pos);
            Intrinsics.checkNotNull((Object)deliveryChuteBlockEntity);
            return deliveryChuteBlockEntity.getRealPos();
        }
        return null;
    }

    public final void tick(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ArrayList<BlockPos> toUnload = new ArrayList<BlockPos>();
        for (BlockPos pos : actives.keySet()) {
            if (level.m_46749_(pos)) continue;
            toUnload.add(pos);
        }
        for (BlockPos pos : toUnload) {
            Intrinsics.checkNotNull((Object)pos);
            this.unloadChute(pos);
        }
        ArrayList<BlockPos> toLoad = new ArrayList<BlockPos>();
        for (BlockPos pos : unloaded.keySet()) {
            if (!level.m_46749_(pos)) continue;
            toLoad.add(pos);
        }
        for (BlockPos pos : toLoad) {
            Intrinsics.checkNotNull((Object)pos);
            this.loadChute(pos);
        }
    }
}

