/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.forge;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.valkyrienskies.clockwork.ClockworkModClient;
import org.valkyrienskies.clockwork.forge.ClockworkModForgeClient;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClockworkClientEvents {
    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        PoseStack ms = event.getPoseStack();
        ms.m_85836_();
        SuperRenderTypeBuffer buffer = SuperRenderTypeBuffer.getInstance();
        float partialTicks = AnimationTickHolder.getPartialTicks();
        Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        ClockworkModClient.getOUTLINER().renderOutlines(ms, SuperRenderTypeBuffer.getInstance(), camera, partialTicks);
        ClockworkModClient.getWANDER_OUTLINER().renderOutlines(ms, SuperRenderTypeBuffer.getInstance(), camera, partialTicks);
        buffer.draw();
        RenderSystem.enableCull();
        ms.m_85849_();
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (!Backend.isGameActive()) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        ClockworkModForgeClient.GRAVITRON_HANDLER.tick();
        ClockworkModClient.getOUTLINER().tickOutlines();
        ClockworkModClient.getWANDER_OUTLINER().tickOutlines();
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        int key = event.getKey();
        boolean pressed = event.getAction() != 0;
        ClockworkModForgeClient.GRAVITRON_HANDLER.onKeyInput(key, pressed);
    }

    @SubscribeEvent
    public static void onMouseScrolled(InputEvent.MouseScrollingEvent event) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        double delta = event.getScrollDelta();
        boolean cancelled = ClockworkModForgeClient.GRAVITRON_HANDLER.mouseScrolled(delta);
        event.setCanceled(cancelled);
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Pre event) {
        boolean pressed;
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        int button = event.getButton();
        boolean bl = pressed = event.getAction() != 0;
        if (ClockworkModForgeClient.GRAVITRON_HANDLER.onMouseInput(button, pressed)) {
            event.setCanceled(true);
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "gravitron", (IGuiOverlay)ClockworkModForgeClient.GRAVITRON_HANDLER);
        }
    }
}

