/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.forge.config;

import com.simibubi.create.content.kinetics.BlockStressValues;
import com.simibubi.create.foundation.config.ConfigBase;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.valkyrienskies.clockwork.forge.config.CWClient;
import org.valkyrienskies.clockwork.forge.config.CWCommon;
import org.valkyrienskies.clockwork.forge.config.CWConfigBase;
import org.valkyrienskies.clockwork.forge.config.CWServer;

public class AllClockworkConfigs {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    public static CWClient CLIENT;
    public static CWCommon COMMON;
    public static CWServer SERVER;

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends CWConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            CWConfigBase config = (CWConfigBase)((Object)((Object)factory.get()));
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        CWConfigBase config = (CWConfigBase)((Object)specPair.getLeft());
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)((Object)config);
    }

    public static void register(ModLoadingContext context) {
        CLIENT = AllClockworkConfigs.register(CWClient::new, ModConfig.Type.CLIENT);
        COMMON = AllClockworkConfigs.register(CWCommon::new, ModConfig.Type.COMMON);
        SERVER = AllClockworkConfigs.register(CWServer::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            context.registerConfig(pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
        BlockStressValues.registerProvider((String)context.getActiveNamespace(), (BlockStressValues.IStressValueProvider)AllClockworkConfigs.SERVER.kinetics.stressValues);
    }

    public static void onLoad(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
    }
}

