/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.SelectedAreaToolkit;
import org.valkyrienskies.clockwork.util.ClockworkConstants;
import org.valkyrienskies.clockwork.util.ClockworkUtils;
import org.valkyrienskies.core.apigame.world.chunks.BlockType;
import org.valkyrienskies.core.impl.util.serialization.VSJacksonUtil;
import org.valkyrienskies.mod.common.BlockStateInfo;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b7\u00108J%\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u0018\u0010\u001cJ\u001f\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ/\u0010(\u001a\u00020'2\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$H\u0007\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010+\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u0010\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010.\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b.\u0010/J\u001d\u00101\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u0017\u00a2\u0006\u0004\b1\u00102J\u0015\u00101\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u0017\u00a2\u0006\u0004\b1\u00103R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u0006048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106\u00a8\u00069"}, d2={"Lorg/valkyrienskies/clockwork/util/ClockworkUtils;", "", "", "x", "y", "z", "Lnet/minecraft/core/Direction;", "fromNormal", "(III)Lnet/minecraft/core/Direction;", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/SelectedAreaToolkit;", "loadArea", "(Lnet/minecraft/nbt/CompoundTag;)Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/SelectedAreaToolkit;", "Lnet/minecraft/nbt/ListTag;", "bbtag", "Lorg/joml/primitives/AABBic;", "readAABBi", "(Lnet/minecraft/nbt/ListTag;)Lorg/joml/primitives/AABBic;", "tag", "Lnet/minecraft/world/phys/Vec3;", "readVec3", "(Lnet/minecraft/nbt/ListTag;)Lnet/minecraft/world/phys/Vec3;", "Lorg/joml/Vector3ic;", "readVector3i", "(Lnet/minecraft/nbt/ListTag;)Lorg/joml/Vector3ic;", "Lnet/minecraft/network/FriendlyByteBuf;", "buf", "(Lnet/minecraft/network/FriendlyByteBuf;)Lorg/joml/Vector3ic;", "area", "saveArea", "(Lnet/minecraft/nbt/CompoundTag;Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/SelectedAreaToolkit;)Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/server/level/ServerLevel;", "serverLevel", "Lnet/minecraft/core/BlockPos;", "blockPos", "", "oldWeight", "newWeight", "", "updateBlockStateWeight", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;DD)V", "bb", "writeAABBi", "(Lorg/joml/primitives/AABBic;)Lnet/minecraft/nbt/ListTag;", "vec", "writeVec3", "(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/nbt/ListTag;", "vector3f", "writeVector3i", "(Lnet/minecraft/network/FriendlyByteBuf;Lorg/joml/Vector3ic;)V", "(Lorg/joml/Vector3ic;)Lnet/minecraft/nbt/ListTag;", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "BY_NORMAL", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "<init>", "()V", "clockwork"})
public final class ClockworkUtils {
    @NotNull
    public static final ClockworkUtils INSTANCE = new ClockworkUtils();
    @NotNull
    private static final Long2ObjectMap<Direction> BY_NORMAL;

    private ClockworkUtils() {
    }

    @JvmStatic
    public static final void updateBlockStateWeight(@NotNull ServerLevel serverLevel, @NotNull BlockPos blockPos, double oldWeight, double newWeight) {
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        BlockState state = serverLevel.m_8055_(blockPos);
        Intrinsics.checkNotNull((Object)state);
        Pair pair = BlockStateInfo.INSTANCE.get(state);
        if (pair == null) {
            return;
        }
        BlockType prevBlockType = (BlockType)pair.component2();
        VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).onSetBlock(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), VSGameUtilsKt.getDimensionId((Level)((Level)serverLevel)), prevBlockType, prevBlockType, oldWeight, newWeight);
    }

    @JvmStatic
    @NotNull
    public static final ListTag writeVec3(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        ListTag tag = new ListTag();
        tag.add((Object)DoubleTag.m_128500_((double)vec.f_82479_));
        tag.add((Object)DoubleTag.m_128500_((double)vec.f_82480_));
        tag.add((Object)DoubleTag.m_128500_((double)vec.f_82481_));
        return tag;
    }

    @JvmStatic
    @NotNull
    public static final Vec3 readVec3(@NotNull ListTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return new Vec3(tag.m_128772_(0), tag.m_128772_(1), tag.m_128772_(2));
    }

    @NotNull
    public final Direction fromNormal(int x, int y, int z) {
        Object object = BY_NORMAL.get(BlockPos.m_121882_((int)x, (int)y, (int)z));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.core.Direction");
        return (Direction)object;
    }

    @NotNull
    public final ListTag writeAABBi(@NotNull AABBic bb) {
        Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
        ListTag bbtag = new ListTag();
        bbtag.add((Object)FloatTag.m_128566_((float)bb.minX()));
        bbtag.add((Object)FloatTag.m_128566_((float)bb.minY()));
        bbtag.add((Object)FloatTag.m_128566_((float)bb.minZ()));
        bbtag.add((Object)FloatTag.m_128566_((float)bb.maxX()));
        bbtag.add((Object)FloatTag.m_128566_((float)bb.maxY()));
        bbtag.add((Object)FloatTag.m_128566_((float)bb.maxZ()));
        return bbtag;
    }

    @Nullable
    public final AABBic readAABBi(@Nullable ListTag bbtag) {
        if (bbtag == null || bbtag.isEmpty()) {
            return null;
        }
        return (AABBic)new AABBi((int)bbtag.m_128775_(0), (int)bbtag.m_128775_(1), (int)bbtag.m_128775_(2), (int)bbtag.m_128775_(3), (int)bbtag.m_128775_(4), (int)bbtag.m_128775_(5));
    }

    @NotNull
    public final ListTag writeVector3i(@NotNull Vector3ic vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        ListTag tag = new ListTag();
        tag.add((Object)IntTag.m_128679_((int)vec.x()));
        tag.add((Object)IntTag.m_128679_((int)vec.y()));
        tag.add((Object)IntTag.m_128679_((int)vec.z()));
        return tag;
    }

    @NotNull
    public final Vector3ic readVector3i(@NotNull ListTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return (Vector3ic)new Vector3i(tag.m_128763_(0), tag.m_128763_(1), tag.m_128763_(2));
    }

    @NotNull
    public final Vector3ic readVector3i(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return (Vector3ic)new Vector3i(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public final void writeVector3i(@NotNull FriendlyByteBuf buf, @NotNull Vector3ic vector3f) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)vector3f, (String)"vector3f");
        buf.writeInt(vector3f.x());
        buf.writeInt(vector3f.y());
        buf.writeInt(vector3f.z());
    }

    @NotNull
    public final SelectedAreaToolkit loadArea(@Nullable CompoundTag nbt) {
        SelectedAreaToolkit toolKit = new SelectedAreaToolkit();
        if (nbt != null) {
            byte[] nb = nbt.m_128463_(ClockworkConstants.Nbt.INSTANCE.getSELECTED_DATA());
            try {
                Object object = VSJacksonUtil.INSTANCE.getDefaultMapper().readValue(nb, SelectedAreaToolkit.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                toolKit.overwriteFrom((SelectedAreaToolkit)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return toolKit;
    }

    @NotNull
    public final CompoundTag saveArea(@NotNull CompoundTag nbt, @Nullable SelectedAreaToolkit area) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        try {
            nbt.m_128382_(ClockworkConstants.Nbt.INSTANCE.getSELECTED_DATA(), VSJacksonUtil.INSTANCE.getDefaultMapper().writeValueAsBytes((Object)area));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return nbt;
    }

    private static final Long BY_NORMAL$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Long)$tmp0.invoke(p0);
    }

    private static final Direction BY_NORMAL$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Direction)$tmp0.invoke(p0);
    }

    private static final Direction BY_NORMAL$lambda$2(Direction direction, Direction direction2) {
        throw new IllegalArgumentException("Duplicate keys");
    }

    private static final Long2ObjectOpenHashMap BY_NORMAL$lambda$3() {
        return new Long2ObjectOpenHashMap();
    }

    static {
        Long2ObjectOpenHashMap long2ObjectOpenHashMap = Arrays.stream(Direction.values()).collect(Collectors.toMap(arg_0 -> ClockworkUtils.BY_NORMAL$lambda$0(BY_NORMAL.1.INSTANCE, arg_0), arg_0 -> ClockworkUtils.BY_NORMAL$lambda$1(BY_NORMAL.2.INSTANCE, arg_0), ClockworkUtils::BY_NORMAL$lambda$2, ClockworkUtils::BY_NORMAL$lambda$3));
        Intrinsics.checkNotNullExpressionValue((Object)long2ObjectOpenHashMap, (String)"collect(...)");
        BY_NORMAL = (Long2ObjectMap)long2ObjectOpenHashMap;
    }
}

