/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4d;
import org.joml.Matrix4d;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.impl.networking.simple.SimplePacket;
import org.valkyrienskies.core.impl.networking.simple.SimplePackets;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.networking.PacketRestartChunkUpdates;
import org.valkyrienskies.mod.common.networking.PacketStopChunkUpdates;
import org.valkyrienskies.mod.common.util.MinecraftPlayer;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.util.RelocationUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/valkyrienskies/clockwork/util/ShipDestroyer;", "", "", "number", "multiple", "roundToNearestMultipleOf", "(DD)D", "Lorg/joml/AxisAngle4d;", "direction", "snapRotation", "(Lorg/joml/AxisAngle4d;)Lorg/joml/AxisAngle4d;", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "Lnet/minecraft/core/Direction;", "", "unfillShip", "(Lnet/minecraft/server/level/ServerLevel;Lorg/valkyrienskies/core/api/ships/ServerShip;Lnet/minecraft/core/Direction;)V", "<init>", "()V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nShipDestroyer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShipDestroyer.kt\norg/valkyrienskies/clockwork/util/ShipDestroyer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1360#2:142\n1446#2,5:143\n1549#2:148\n1620#2,3:149\n1855#2,2:152\n1855#2,2:154\n*S KotlinDebug\n*F\n+ 1 ShipDestroyer.kt\norg/valkyrienskies/clockwork/util/ShipDestroyer\n*L\n82#1:142\n82#1:143,5\n83#1:148\n83#1:149,3\n87#1:152,2\n136#1:154,2\n*E\n"})
public final class ShipDestroyer {
    @NotNull
    public static final ShipDestroyer INSTANCE = new ShipDestroyer();

    private ShipDestroyer() {
    }

    private final double roundToNearestMultipleOf(double number, double multiple) {
        return multiple * Math.rint(number / multiple);
    }

    private final AxisAngle4d snapRotation(AxisAngle4d direction) {
        AxisAngle4d axisAngle4d;
        double x = Math.abs(direction.x);
        double y = Math.abs(direction.y);
        double z = Math.abs(direction.z);
        double angle = this.roundToNearestMultipleOf(direction.angle, 1.5707963267948966);
        if (x > y && x > z) {
            AxisAngle4d axisAngle4d2 = direction.set(angle, Math.signum(direction.x), 0.0, 0.0);
            Intrinsics.checkNotNull((Object)axisAngle4d2);
            axisAngle4d = axisAngle4d2;
        } else if (y > x && y > z) {
            AxisAngle4d axisAngle4d3 = direction.set(angle, 0.0, Math.signum(direction.y), 0.0);
            Intrinsics.checkNotNull((Object)axisAngle4d3);
            axisAngle4d = axisAngle4d3;
        } else {
            AxisAngle4d axisAngle4d4 = direction.set(angle, 0.0, 0.0, Math.signum(direction.z));
            Intrinsics.checkNotNull((Object)axisAngle4d4);
            axisAngle4d = axisAngle4d4;
        }
        return axisAngle4d;
    }

    /*
     * WARNING - void declaration
     */
    public final void unfillShip(@NotNull ServerLevel level, @NotNull ServerShip ship, @NotNull Direction direction) {
        Iterator $this$mapTo$iv$iv;
        Object element$iv$iv2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        ship.setStatic(true);
        ShipTransform $this$unfillShip_u24lambda_u240 = ship.getTransform();
        boolean bl = false;
        Matrix4d shipToWorld = new Matrix4d().translate($this$unfillShip_u24lambda_u240.getPositionInWorld()).rotate(INSTANCE.snapRotation(new AxisAngle4d($this$unfillShip_u24lambda_u240.getShipToWorldRotation()))).scale($this$unfillShip_u24lambda_u240.getShipToWorldScaling()).translate(-$this$unfillShip_u24lambda_u240.getPositionInShip().x(), -$this$unfillShip_u24lambda_u240.getPositionInShip().y(), -$this$unfillShip_u24lambda_u240.getPositionInShip().z());
        Vector3d alloc0 = new Vector3d();
        Rotation rotation = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> Rotation.NONE;
            case 2 -> Rotation.CLOCKWISE_180;
            case 3 -> Rotation.COUNTERCLOCKWISE_90;
            case 4 -> Rotation.CLOCKWISE_90;
            default -> Rotation.NONE;
        };
        Map chunksToBeUpdated = new LinkedHashMap();
        ship.getActiveChunksSet().forEach((arg_0, arg_1) -> ShipDestroyer.unfillShip$lambda$1(chunksToBeUpdated, arg_0, arg_1));
        List chunkPairs = CollectionsKt.toList((Iterable)chunksToBeUpdated.values());
        Iterable $this$flatMap$iv = chunkPairs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            Pair it = (Pair)element$iv$iv2;
            boolean bl2 = false;
            Iterable list$iv$iv = TuplesKt.toList((Pair)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List chunkPoses = (List)destination$iv$iv;
        Iterable $this$map$iv = chunkPoses;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        element$iv$iv2 = $this$mapTo$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            void it;
            Object item$iv$iv = element$iv$iv2.next();
            ChunkPos bl2 = (ChunkPos)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(VectorConversionsMCKt.toJOML((ChunkPos)it));
        }
        List chunkPosesJOML = (List)destination$iv$iv2;
        List list = level.m_6907_();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl4 = false;
            SimplePacket simplePacket = (SimplePacket)new PacketStopChunkUpdates(chunkPosesJOML);
            Intrinsics.checkNotNull((Object)player);
            MinecraftPlayer minecraftPlayer = VSGameUtilsKt.getPlayerWrapper((Player)((Player)player));
            Intrinsics.checkNotNullExpressionValue((Object)minecraftPlayer, (String)"<get-playerWrapper>(...)");
            SimplePackets.sendToClient((SimplePacket)simplePacket, (IPlayer)((IPlayer)minecraftPlayer));
        }
        HashSet toUpdate = Sets.newHashSet();
        ship.getActiveChunksSet().forEach((arg_0, arg_1) -> ShipDestroyer.unfillShip$lambda$5(level, shipToWorld, alloc0, toUpdate, rotation, arg_0, arg_1));
        for (Triple triple : toUpdate) {
            RelocationUtilKt.updateBlock((Level)((Level)level), (BlockPos)((BlockPos)triple.getFirst()), (BlockPos)((BlockPos)triple.getSecond()), (BlockState)((BlockState)triple.getThird()));
        }
        MinecraftServer minecraftServer = level.m_7654_();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        VSGameUtilsKt.executeIf((MinecraftServer)minecraftServer, (Function0)((Function0)new Function0<Boolean>((List<? extends ChunkPos>)chunkPoses, level){
            final /* synthetic */ List<ChunkPos> $chunkPoses;
            final /* synthetic */ ServerLevel $level;
            {
                this.$chunkPoses = $chunkPoses;
                this.$level = $level;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block3: {
                    void $this$all$iv;
                    Iterable iterable = this.$chunkPoses;
                    ServerLevel serverLevel = this.$level;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            ChunkPos p0 = (ChunkPos)element$iv;
                            boolean bl2 = false;
                            if (VSGameUtilsKt.isTickingChunk((Level)((Level)serverLevel), (ChunkPos)p0)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
        }), () -> ShipDestroyer.unfillShip$lambda$7(level, chunkPosesJOML));
    }

    private static final void unfillShip$lambda$1(Map $chunksToBeUpdated, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)$chunksToBeUpdated, (String)"$chunksToBeUpdated");
        $chunksToBeUpdated.put(new ChunkPos(chunkX, chunkZ), new Pair((Object)new ChunkPos(chunkX, chunkZ), (Object)new ChunkPos(chunkX, chunkZ)));
    }

    private static final void unfillShip$lambda$5(ServerLevel $level, Matrix4d $shipToWorld, Vector3d $alloc0, HashSet $toUpdate, Rotation $rotation, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$alloc0, (String)"$alloc0");
        Intrinsics.checkNotNullParameter((Object)$rotation, (String)"$rotation");
        LevelChunk chunk = $level.m_6325_(chunkX, chunkZ);
        int n = chunk.m_7103_().length;
        for (int sectionIndex = 0; sectionIndex < n; ++sectionIndex) {
            LevelChunkSection section = chunk.m_7103_()[sectionIndex];
            if (section == null || section.m_188008_()) continue;
            int bottomY = sectionIndex << 4;
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        BlockState state = section.m_62982_(x, y, z);
                        if (state.m_60795_()) continue;
                        int realX = (chunkX << 4) + x;
                        int realY = bottomY + y + $level.m_141937_();
                        int realZ = (chunkZ << 4) + z;
                        Vector3d inWorldPos = $shipToWorld.transformPosition($alloc0.set((double)realX + 0.5, (double)realY + 0.5, (double)realZ + 0.5)).floor();
                        BlockPos inWorldBlockPos = new BlockPos((int)inWorldPos.x, (int)inWorldPos.y, (int)inWorldPos.z);
                        BlockPos inShipPos = new BlockPos(realX, realY, realZ);
                        $toUpdate.add(new Triple((Object)inShipPos, (Object)inWorldBlockPos, (Object)state));
                        RelocationUtilKt.relocateBlock((Level)((Level)$level), (BlockPos)inShipPos, (BlockPos)inWorldBlockPos, (boolean)false, null, (Rotation)$rotation);
                    }
                }
            }
        }
    }

    private static final void unfillShip$lambda$7(ServerLevel $level, List $chunkPosesJOML) {
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$chunkPosesJOML, (String)"$chunkPosesJOML");
        List list = $level.m_6907_();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl = false;
            SimplePacket simplePacket = (SimplePacket)new PacketRestartChunkUpdates($chunkPosesJOML);
            Intrinsics.checkNotNull((Object)player);
            MinecraftPlayer minecraftPlayer = VSGameUtilsKt.getPlayerWrapper((Player)((Player)player));
            Intrinsics.checkNotNullExpressionValue((Object)minecraftPlayer, (String)"<get-playerWrapper>(...)");
            SimplePackets.sendToClient((SimplePacket)simplePacket, (IPlayer)((IPlayer)minecraftPlayer));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.SOUTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

