/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.recipe.forge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.resources.recipe.BlockTypeSwapIngredient;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class BlockTypeSwapIngredientImpl<T extends BlockType>
extends AbstractIngredient
implements BlockTypeSwapIngredient {
    private final Ingredient inner;
    private final T fromType;
    private final T toType;
    private final BlockTypeRegistry<T> registry;
    private ItemStack[] items;
    private static final IIngredientSerializer<BlockTypeSwapIngredientImpl<?>> SERIALIZER = new IIngredientSerializer<BlockTypeSwapIngredientImpl<?>>(){

        public BlockTypeSwapIngredientImpl<?> parse(FriendlyByteBuf arg) {
            BlockTypeRegistry<?> reg = BlockSetInternal.getByName(arg.m_130277_());
            Object from = reg.getFromNBT(arg.m_130277_());
            Object to = reg.getFromNBT(arg.m_130277_());
            Ingredient ing = Ingredient.m_43940_((FriendlyByteBuf)arg);
            return new BlockTypeSwapIngredientImpl(ing, from, to, reg);
        }

        public BlockTypeSwapIngredientImpl<?> parse(JsonObject jsonObject) {
            BlockTypeRegistry<?> reg = BlockSetInternal.REGISTRIES_BY_NAME.getValue(jsonObject.get("block_type").getAsString());
            Object from = reg.getFromNBT(jsonObject.get("from").getAsString());
            Object to = reg.getFromNBT(jsonObject.get("to").getAsString());
            Ingredient ing = Ingredient.m_43917_((JsonElement)jsonObject.get("ingredient"));
            return new BlockTypeSwapIngredientImpl(ing, from, to, reg);
        }

        public void write(FriendlyByteBuf buf, BlockTypeSwapIngredientImpl ing) {
            buf.m_130070_(ing.registry.typeName());
            buf.m_130070_(((BlockType)ing.fromType).getId().toString());
            buf.m_130070_(((BlockType)ing.toType).getId().toString());
            ing.inner.m_43923_(buf);
        }
    };

    public BlockTypeSwapIngredientImpl(Ingredient inner, T fromType, T toType, BlockTypeRegistry<T> registry) {
        this.inner = inner;
        this.fromType = fromType;
        this.toType = toType;
        this.registry = registry;
    }

    @Override
    public Ingredient getInner() {
        return this.inner;
    }

    public boolean isSimple() {
        return false;
    }

    @Override
    public List<ItemStack> convertItems(List<ItemStack> toConvert) {
        ItemStack it;
        T type;
        ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
        boolean success = false;
        Iterator<ItemStack> iterator = toConvert.iterator();
        while (iterator.hasNext() && (type = this.registry.getBlockTypeOf((ItemLike)(it = iterator.next()).m_41720_())) == this.fromType) {
            Item newItem = BlockType.changeItemType(it.m_41720_(), this.fromType, this.toType);
            if (newItem == null) continue;
            newItems.add(new ItemStack((ItemLike)newItem));
            success = true;
        }
        if (!success) {
            newItems.addAll(toConvert);
        }
        return newItems;
    }

    public ItemStack[] m_43908_() {
        if (this.items == null) {
            ItemStack[] original = this.inner.m_43908_();
            this.items = this.convertItems(Arrays.asList(original)).toArray(new ItemStack[0]);
        }
        return this.items;
    }

    protected void invalidate() {
        super.invalidate();
        this.items = null;
    }

    public IIngredientSerializer<BlockTypeSwapIngredientImpl<?>> getSerializer() {
        return SERIALIZER;
    }

    public JsonElement m_43942_() {
        JsonObject obj = new JsonObject();
        obj.addProperty("block_type", this.registry.typeName());
        obj.addProperty("from", ((BlockType)this.fromType).getId().toString());
        obj.addProperty("to", ((BlockType)this.toType).getId().toString());
        obj.add("ingredient", this.inner.m_43942_());
        obj.addProperty("type", CraftingHelper.getID(SERIALIZER).toString());
        return obj;
    }

    public static <T extends BlockType> Ingredient create(Ingredient original, T from, T to) {
        return new BlockTypeSwapIngredientImpl<T>(original, from, to, from.getRegistry());
    }

    public static void init() {
        CraftingHelper.register((ResourceLocation)Moonlight.res("block_type_swap"), SERIALIZER);
    }
}

