/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;

public class PacketItemEnterPipe {
    private BlockPos tilePos;
    private CompoundTag item;

    public PacketItemEnterPipe(BlockPos tilePos, IPipeItem item) {
        this.tilePos = tilePos;
        this.item = (CompoundTag)item.serializeNBT();
    }

    private PacketItemEnterPipe() {
    }

    public static PacketItemEnterPipe fromBytes(FriendlyByteBuf buf) {
        PacketItemEnterPipe client = new PacketItemEnterPipe();
        client.tilePos = buf.m_130135_();
        client.item = buf.m_130260_();
        return client;
    }

    public static void toBytes(PacketItemEnterPipe packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.tilePos);
        buf.m_130079_(packet.item);
    }

    public static void onMessage(final PacketItemEnterPipe message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ == null) {
                    return;
                }
                IPipeItem item = IPipeItem.load(message.item);
                PipeBlockEntity pipe = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)mc.f_91073_, message.tilePos);
                if (pipe != null) {
                    pipe.getItems().add(item);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

