/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import immersive_aircraft.client.render.entity.renderer.utils.ModelPartRenderHandler;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.resources.bbmodel.BBAnimation;
import immersive_aircraft.resources.bbmodel.BBAnimator;
import immersive_aircraft.resources.bbmodel.BBBone;
import immersive_aircraft.resources.bbmodel.BBFace;
import immersive_aircraft.resources.bbmodel.BBFaceContainer;
import immersive_aircraft.resources.bbmodel.BBMesh;
import immersive_aircraft.resources.bbmodel.BBModel;
import immersive_aircraft.resources.bbmodel.BBObject;
import immersive_aircraft.util.Utils;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BBModelRenderer {
    public static <T extends VehicleEntity> void renderModel(BBModel model, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float time, T entity, ModelPartRenderHandler<T> modelPartRenderer, float red, float green, float blue, float alpha) {
        model.root.forEach(object -> BBModelRenderer.renderObject(model, object, matrixStack, vertexConsumerProvider, light, time, entity, modelPartRenderer, red, green, blue, alpha));
    }

    public static <T extends VehicleEntity> void renderObject(BBModel model, BBObject object, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float time, T entity, ModelPartRenderHandler<T> modelPartRenderer, float red, float green, float blue, float alpha) {
        BBAnimation animation;
        matrixStack.m_85836_();
        matrixStack.m_252880_(object.origin.x(), object.origin.y(), object.origin.z());
        if (!model.animations.isEmpty() && (animation = model.animations.get(0)).hasAnimator(object.uuid)) {
            Vector3f position = animation.sample(object.uuid, BBAnimator.Channel.POSITION, time);
            position.mul(0.0625f);
            matrixStack.m_252880_(position.x(), position.y(), position.z());
            Vector3f rotation = animation.sample(object.uuid, BBAnimator.Channel.ROTATION, time);
            rotation.mul(0.017453294f);
            matrixStack.m_252781_(Utils.fromXYZ(rotation));
            Vector3f scale = animation.sample(object.uuid, BBAnimator.Channel.SCALE, time);
            matrixStack.m_85841_(scale.x(), scale.y(), scale.z());
        }
        matrixStack.m_252781_(Utils.fromXYZ(object.rotation));
        if (object instanceof BBBone) {
            BBBone bone = (BBBone)object;
            if (modelPartRenderer != null) {
                modelPartRenderer.animate(bone.name, entity, matrixStack, time);
            }
        }
        if (object instanceof BBBone) {
            matrixStack.m_252880_(-object.origin.x(), -object.origin.y(), -object.origin.z());
        }
        if (modelPartRenderer == null || !modelPartRenderer.render(object.name, model, object, vertexConsumerProvider, entity, matrixStack, light, time, modelPartRenderer)) {
            BBModelRenderer.renderObjectInner(model, object, matrixStack, vertexConsumerProvider, light, time, entity, modelPartRenderer, red, green, blue, alpha);
        }
        matrixStack.m_85849_();
    }

    public static <T extends VehicleEntity> void renderObjectInner(BBModel model, BBObject object, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float time, T entity, ModelPartRenderHandler<T> modelPartRenderer, float red, float green, float blue, float alpha) {
        if (object instanceof BBFaceContainer) {
            BBFaceContainer cube = (BBFaceContainer)((Object)object);
            BBModelRenderer.renderFaces(cube, matrixStack, vertexConsumerProvider, light, red, green, blue, alpha, null);
        } else if (object instanceof BBBone) {
            BBBone bone = (BBBone)object;
            boolean shouldRender = bone.visibility;
            if (bone.name.equals("lod0")) {
                shouldRender = entity.isWithinParticleRange();
            } else if (bone.name.equals("lod1")) {
                boolean bl = shouldRender = !entity.isWithinParticleRange();
            }
            if (shouldRender) {
                bone.children.forEach(child -> BBModelRenderer.renderObject(model, child, matrixStack, vertexConsumerProvider, light, time, entity, modelPartRenderer, red, green, blue, alpha));
            }
        }
    }

    public static void renderFaces(BBFaceContainer cube, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float red, float green, float blue, float alpha, VertexConsumer overrideVertexConsumer) {
        PoseStack.Pose last = matrixStack.m_85850_();
        Matrix4f positionMatrix = last.m_252922_();
        Matrix3f normalMatrix = last.m_252943_();
        for (BBFace face : cube.getFaces()) {
            VertexConsumer vertexConsumer = overrideVertexConsumer == null ? vertexConsumerProvider.m_6299_(cube.enableCulling() ? RenderType.m_110452_((ResourceLocation)face.texture.location) : RenderType.m_110458_((ResourceLocation)face.texture.location)) : overrideVertexConsumer;
            for (int i = 0; i < 4; ++i) {
                BBFace.BBVertex v = face.vertices[i];
                vertexConsumer.m_252986_(positionMatrix, v.x, v.y, v.z);
                vertexConsumer.m_85950_(red, green, blue, alpha);
                vertexConsumer.m_7421_(v.u, v.v);
                vertexConsumer.m_86008_(OverlayTexture.f_118083_);
                vertexConsumer.m_85969_(light);
                vertexConsumer.m_252939_(normalMatrix, v.nx, v.ny, v.nz);
                vertexConsumer.m_5752_();
            }
        }
    }

    public static void renderBanner(BBFaceContainer cube, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light, boolean isBanner, List<Pair<Holder<BannerPattern>, DyeColor>> patterns) {
        matrixStack.m_85836_();
        if (cube instanceof BBObject) {
            BBObject object = (BBObject)((Object)cube);
            matrixStack.m_252880_(object.origin.x(), object.origin.y(), object.origin.z());
        }
        for (int i = 0; i < 17 && i < patterns.size(); ++i) {
            Pair<Holder<BannerPattern>, DyeColor> pair = patterns.get(i);
            Holder bannerPattern = (Holder)pair.getFirst();
            bannerPattern.m_203543_().map(key -> isBanner ? Sheets.m_234347_((ResourceKey)key) : Sheets.m_234349_((ResourceKey)key)).ifPresent(material -> {
                VertexConsumer vertexConsumer = material.m_119194_(vertexConsumers, RenderType::m_110482_);
                float[] fs = ((DyeColor)pair.getSecond()).m_41068_();
                BBModelRenderer.renderFaces(cube, matrixStack, vertexConsumers, light, fs[0], fs[1], fs[2], 1.0f, vertexConsumer);
            });
        }
        matrixStack.m_85849_();
    }

    public static void renderSailObject(BBMesh cube, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float time, float red, float green, float blue, float alpha) {
        BBModelRenderer.renderSailObject(cube, matrixStack, vertexConsumerProvider, light, time, red, green, blue, alpha, 0.025f, 0.0f);
    }

    public static void renderSailObject(BBMesh cube, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, float time, float red, float green, float blue, float alpha, float distanceScale, float baseScale) {
        PoseStack.Pose last = matrixStack.m_85850_();
        Matrix4f positionMatrix = last.m_252922_();
        Matrix3f normalMatrix = last.m_252943_();
        for (BBFace face : cube.getFaces()) {
            VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)face.texture.location));
            for (int i = 0; i < 4; ++i) {
                BBFace.BBVertex v = face.vertices[i];
                float distance = Math.max(Math.max(Math.abs(v.x), Math.abs(v.y)), Math.abs(v.z));
                double angle = ((double)(v.x + v.z) + (double)v.y * 0.25) * 4.0 + (double)(time * 4.0f);
                double scale = distanceScale * distance + baseScale;
                float x = (float)((Math.cos(angle) + Math.cos(angle * 1.7)) * scale);
                float z = (float)((Math.sin(angle) + Math.sin(angle * 1.7)) * scale);
                vertexConsumer.m_252986_(positionMatrix, v.x + x, v.y, v.z + z).m_85950_(red, green, blue, alpha).m_7421_(v.u, v.v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, v.nx, v.ny, v.nz).m_5752_();
            }
        }
    }
}

