/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import com.google.common.collect.Lists;
import com.mojang.math.Axis;
import earth.terrarium.adastra.api.systems.GravityApi;
import immersive_aircraft.CompatUtil;
import immersive_aircraft.Main;
import immersive_aircraft.Sounds;
import immersive_aircraft.client.KeyBindings;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.data.VehicleDataLoader;
import immersive_aircraft.entity.misc.BoundingBoxDescriptor;
import immersive_aircraft.entity.misc.PositionDescriptor;
import immersive_aircraft.network.c2s.CollisionMessage;
import immersive_aircraft.network.c2s.CommandMessage;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.util.InterpolatedFloat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class VehicleEntity
extends Entity {
    public final ResourceLocation identifier;
    private static final EntityDataAccessor<Float> DATA_HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> DAMAGE_WOBBLE_TICKS = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DAMAGE_WOBBLE_SIDE = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> DAMAGE_WOBBLE_STRENGTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected final boolean canExplodeOnCrash;
    protected static final EntityDataAccessor<Integer> BOOST = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected int interpolationSteps;
    protected int lastTriedToExit;
    protected double x;
    protected double y;
    protected double z;
    protected double serverYRot;
    protected double serverXRot;
    protected float movementX;
    protected float movementY;
    protected float movementZ;
    public final InterpolatedFloat pressingInterpolatedX;
    public final InterpolatedFloat pressingInterpolatedY;
    public final InterpolatedFloat pressingInterpolatedZ;
    public float roll;
    public float prevRoll;
    public double lastX;
    public double lastY;
    public double lastZ;
    public double secondLastX;
    public double secondLastY;
    public double secondLastZ;
    public boolean adaptPlayerRotation = true;
    private int drowning;
    protected static final Vector4f ZERO_VEC4 = new Vector4f();

    public float getRoll() {
        return this.roll;
    }

    public float getRoll(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.prevRoll, (float)this.getRoll());
    }

    public void m_146926_(float pitch) {
        float loops = (float)(Math.floor((pitch + 180.0f) / 360.0f) * 360.0);
        this.f_19860_ -= loops;
        super.m_146926_(pitch -= loops);
    }

    public void setZRot(float rot) {
        this.roll = rot;
    }

    public void boost() {
        this.boost(100);
    }

    public void boost(int ticks) {
        this.f_19804_.m_135381_(BOOST, (Object)ticks);
    }

    protected void applyBoost() {
    }

    public boolean canBoost() {
        return false;
    }

    public int getBoost() {
        return (Integer)this.f_19804_.m_135370_(BOOST);
    }

    public List<List<PositionDescriptor>> getPassengerPositions() {
        return VehicleDataLoader.get(this.identifier).getPassengerPositions();
    }

    public int getPassengerSpace() {
        return this.getPassengerPositions().size();
    }

    public VehicleEntity(EntityType<? extends VehicleEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world);
        this.canExplodeOnCrash = canExplodeOnCrash;
        this.f_19850_ = true;
        this.m_274367_(0.55f);
        this.pressingInterpolatedX = new InterpolatedFloat(this.getInputInterpolationSteps());
        this.pressingInterpolatedY = new InterpolatedFloat(this.getInputInterpolationSteps());
        this.pressingInterpolatedZ = new InterpolatedFloat(this.getInputInterpolationSteps());
        this.identifier = BuiltInRegistries.f_256780_.m_7981_((Object)this.m_6095_());
    }

    public void fromItemStack(ItemStack stack) {
        if (stack.m_41782_()) {
            assert (stack.m_41783_() != null);
            this.readItemTag(stack.m_41783_());
        }
    }

    protected float getInputInterpolationSteps() {
        return 10.0f;
    }

    protected float m_6380_(@NotNull Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE_WOBBLE_TICKS, (Object)0);
        this.f_19804_.m_135372_(DAMAGE_WOBBLE_SIDE, (Object)1);
        this.f_19804_.m_135372_(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_HEALTH, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(BOOST, (Object)0);
    }

    public boolean m_7337_(@NotNull Entity other) {
        return VehicleEntity.canCollide(this, other);
    }

    public static boolean canCollide(Entity entity, Entity other) {
        return (other.m_5829_() || other.m_6094_()) && !entity.m_20365_(other);
    }

    public boolean m_5829_() {
        return true;
    }

    protected Vec3 m_7643_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Direction.Axis portalAxis, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockUtil.FoundRectangle portalRect) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(portalAxis, portalRect));
    }

    public boolean m_7313_(@NotNull Entity attacker) {
        return this.m_20363_(attacker) || super.m_7313_(attacker);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return true;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) {
                this.dropInventory();
                this.m_146870_();
                return true;
            }
        }
        if (amount > 0.0f && source.m_7639_() instanceof Player && this.m_20197_().isEmpty() && !source.m_269014_()) {
            amount = Math.max(5.0f, amount);
        }
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength((float)((double)this.getDamageWobbleStrength() + Math.sqrt(amount) * 5.0 / (double)(1.0f + this.getDamageWobbleStrength() * 0.05f)));
        this.m_146852_(GameEvent.f_223706_, source.m_7639_());
        boolean force = !(source.m_7640_() instanceof Player);
        this.applyDamage(amount / this.getDurability() / (float)Config.getInstance().damagePerHealthPoint, force);
        return true;
    }

    private void applyDamage(float amount, boolean force) {
        if (this.m_213877_()) {
            return;
        }
        float health = this.getHealth() - amount;
        if (health <= 0.0f) {
            this.setHealth(0.0f);
            if (force && this.canExplodeOnCrash && Config.getInstance().enableCrashExplosion) {
                this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), Config.getInstance().crashExplosionRadius, Config.getInstance().enableCrashFire, Config.getInstance().enableCrashBlockDestruction ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE);
            }
            if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_) && Config.getInstance().enableDropsForNonPlayer) {
                this.dropInventory();
                this.drop();
            }
            this.m_146870_();
        } else {
            this.setHealth(health);
        }
    }

    private void repair(float amount) {
        float health = Math.min(1.0f, this.getHealth() + amount);
        this.setHealth(health);
    }

    public float getDurability() {
        return 1.0f;
    }

    protected void drop() {
        ItemStack stack = new ItemStack((ItemLike)this.asItem());
        CompoundTag tag = stack.m_41784_();
        this.addItemTag(tag);
        this.m_19983_(stack);
    }

    protected void dropInventory() {
    }

    public void m_6845_(boolean drag) {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)this.f_19796_.m_188501_(), this.m_20186_() + 0.7, this.m_20189_() + (double)this.f_19796_.m_188501_(), 0.0, 0.0, 0.0);
        if (this.f_19796_.m_188503_(20) == 0) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5509_(), this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_(), false);
        }
        this.m_146852_(GameEvent.f_157784_, (Entity)this.m_6688_());
    }

    public Item asItem() {
        return Items.f_42398_;
    }

    public void m_6053_(float yaw) {
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() * 11.0f);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    private static float getMovementMultiplier(boolean positive, boolean negative) {
        if (positive == negative) {
            return 0.0f;
        }
        return positive ? 1.0f : -1.0f;
    }

    protected boolean useAirplaneControls() {
        return false;
    }

    public void m_8119_() {
        int t;
        if (this.f_19797_ % 10 == 0) {
            this.secondLastX = this.lastX;
            this.secondLastY = this.lastY;
            this.secondLastZ = this.lastZ;
            this.lastX = this.m_20185_();
            this.lastY = this.m_20186_();
            this.lastZ = this.m_20189_();
            if (this.secondLastX == 0.0 && this.secondLastY == 0.0 && this.secondLastZ == 0.0) {
                this.secondLastX = this.lastX;
                this.secondLastY = this.lastY;
                this.secondLastZ = this.lastZ;
            }
        }
        if (!this.m_20197_().isEmpty()) {
            this.tickPilot();
        }
        if (this.getDamageWobbleTicks() > 0) {
            this.setDamageWobbleTicks(this.getDamageWobbleTicks() - 1);
        }
        if (this.getDamageWobbleStrength() > 0.0f) {
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() - 1.0f);
        }
        super.m_8119_();
        this.handleClientSync();
        int boost = this.getBoost();
        if (boost > 0) {
            this.f_19804_.m_135381_(BOOST, (Object)(boost - 1));
        }
        if (this.m_6109_()) {
            this.updateVelocity();
            if (boost > 0) {
                this.applyBoost();
            }
            this.updateController();
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        this.m_20101_();
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean bl = !this.m_9236_().f_46443_ && !(this.m_6688_() instanceof Player);
            for (Entity entity : list) {
                if (entity.m_20363_((Entity)this) || !bl || this.m_20197_().size() >= this.getPassengerSpace() - 1 || entity.m_20159_() || !(entity.m_20205_() < this.m_20205_()) || !(entity instanceof LivingEntity) || entity instanceof WaterAnimal || entity instanceof Player) continue;
                entity.m_20329_((Entity)this);
            }
        }
        if (this.m_6109_()) {
            this.pressingInterpolatedX.update(this.movementX);
            this.pressingInterpolatedY.update(this.movementY);
            this.pressingInterpolatedZ.update(this.movementZ);
        }
        this.tickDamageParticles();
        if (!this.m_9236_().f_46443_ && (t = Config.getInstance().regenerateHealthEveryNTicks) > 0 && this.m_9236_().m_46467_() % (long)t == 0L) {
            this.repair(0.05f / this.getDurability());
        }
    }

    private void tickDamageParticles() {
        double z;
        double y;
        double x;
        Vec3 center;
        if (this.m_9236_().f_46443_ && this.f_19796_.m_188501_() > this.getHealth()) {
            List<AABB> shapes = this.getShapes();
            AABB shape = shapes.get(this.f_19796_.m_188503_(shapes.size()));
            center = shape.m_82399_();
            x = center.f_82479_ + shape.m_82362_() * (this.f_19796_.m_188500_() - 0.5) * 1.5;
            y = center.f_82480_ + shape.m_82376_() * (this.f_19796_.m_188500_() - 0.5) * 1.5;
            z = center.f_82481_ + shape.m_82385_() * (this.f_19796_.m_188500_() - 0.5) * 1.5;
            Vec3 speed = this.getSpeedVector();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, speed.f_82479_, speed.f_82480_, speed.f_82481_);
            if ((double)this.getHealth() < 0.5) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175834_, x, y, z, speed.f_82479_, speed.f_82480_, speed.f_82481_);
            }
        }
        if (this.m_5842_() && this.drowning < 200) {
            ++this.drowning;
            for (AABB shape : this.getShapes()) {
                center = shape.m_82399_();
                x = center.f_82479_ + shape.m_82362_() * (this.f_19796_.m_188500_() - 0.5) * 1.5;
                y = center.f_82480_ + shape.m_82376_() * (this.f_19796_.m_188500_() - 0.5) * 1.5;
                z = center.f_82481_ + shape.m_82385_() * (this.f_19796_.m_188500_() - 0.5) * 1.5;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void tickPilot() {
        Player player;
        for (Entity entity : this.m_20197_()) {
            Player player2;
            if (!(entity instanceof Player) || !(player2 = (Player)entity).m_7578_()) continue;
            if (KeyBindings.down.m_90857_() && this.m_20096_() && this.m_20184_().m_82553_() < 0.01) {
                player2.m_5661_((Component)Component.m_237110_((String)"mount.onboard", (Object[])new Object[]{KeyBindings.dismount.m_90863_()}), true);
            }
            if (KeyBindings.dismount.m_90859_()) {
                if (this.m_20096_() || this.f_19797_ - this.lastTriedToExit < 20) {
                    NetworkHandler.sendToServer(new CommandMessage(CommandMessage.Key.DISMOUNT, this.m_20184_()));
                    player2.m_6862_(false);
                } else {
                    this.lastTriedToExit = this.f_19797_;
                    player2.m_5661_((Component)Component.m_237115_((String)"immersive_aircraft.tried_dismount"), true);
                }
            }
            if (!KeyBindings.boost.m_90859_() || !this.canBoost()) continue;
            NetworkHandler.sendToServer(new CommandMessage(CommandMessage.Key.BOOST, this.m_20184_()));
            Vec3 p = this.m_20182_();
            this.m_9236_().m_7785_(p.m_7096_(), p.m_7098_(), p.m_7094_(), SoundEvents.f_11932_, SoundSource.NEUTRAL, 1.0f, 1.0f, true);
        }
        Entity pilot = (Entity)this.m_20197_().get(0);
        if (pilot instanceof Player && (player = (Player)pilot).m_7578_()) {
            this.setInputs(VehicleEntity.getMovementMultiplier(KeyBindings.left.m_90857_(), KeyBindings.right.m_90857_()), VehicleEntity.getMovementMultiplier(KeyBindings.up.m_90857_(), KeyBindings.down.m_90857_()), VehicleEntity.getMovementMultiplier(this.useAirplaneControls() ? KeyBindings.push.m_90857_() : KeyBindings.forward.m_90857_(), this.useAirplaneControls() ? KeyBindings.pull.m_90857_() : KeyBindings.backward.m_90857_()));
        } else {
            this.setInputs(0.0f, 0.0f, 0.0f);
        }
    }

    private void handleClientSync() {
        if (this.m_6109_()) {
            this.interpolationSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedX = this.m_20185_() + (this.x - this.m_20185_()) / (double)this.interpolationSteps;
        double interpolatedY = this.m_20186_() + (this.y - this.m_20186_()) / (double)this.interpolationSteps;
        double interpolatedZ = this.m_20189_() + (this.z - this.m_20189_()) / (double)this.interpolationSteps;
        double interpolatedYaw = Mth.m_14175_((double)(this.serverYRot - (double)this.m_146908_()));
        this.m_146922_(this.m_146908_() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.m_146926_(this.m_146909_() + (float)(this.serverXRot - (double)this.m_146909_()) / (float)this.interpolationSteps);
        this.m_6034_(interpolatedX, interpolatedY, interpolatedZ);
        this.m_19915_(this.m_146908_(), this.m_146909_());
        --this.interpolationSteps;
    }

    protected abstract void updateVelocity();

    protected float getGravity() {
        return -0.04f * (CompatUtil.isModLoaded("ad_astra") ? GravityApi.API.getGravity(this.m_9236_(), BlockPos.m_274446_((Position)this.m_146892_())) : 1.0f);
    }

    protected abstract void updateController();

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction positionUpdater) {
        int i;
        List<List<PositionDescriptor>> positions;
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform();
        int size = this.m_20197_().size() - 1;
        if (size < (positions = this.getPassengerPositions()).size() && (i = this.m_20197_().indexOf(passenger)) >= 0 && i < positions.get(size).size()) {
            PositionDescriptor positionDescriptor = positions.get(size).get(i);
            float x = positionDescriptor.x();
            float y = positionDescriptor.y();
            float z = positionDescriptor.z();
            if (passenger instanceof Animal) {
                z += 0.2f;
            }
            Vector4f worldPosition = this.transformPosition(transform, x, y += (float)passenger.m_6049_(), z);
            passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            if (this.adaptPlayerRotation) {
                passenger.m_146922_(passenger.m_146908_() + (this.m_146908_() - this.f_19859_));
                passenger.m_5616_(passenger.m_6080_() + (this.m_146908_() - this.f_19859_));
            }
            positionUpdater.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            this.copyEntityData(passenger);
            if (passenger instanceof Animal) {
                Animal animal = (Animal)passenger;
                if (size > 1) {
                    int angle = passenger.m_19879_() % 2 == 0 ? 90 : 270;
                    passenger.m_5618_(animal.f_20883_ + (float)angle);
                    passenger.m_5616_(passenger.m_6080_() + (float)angle);
                }
            }
        }
    }

    private Vec3 getDismountOffset(double vehicleWidth, double passengerWidth) {
        double offset = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float yaw = this.m_146908_() + 90.0f;
        float x = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180)));
        float n = Math.max(Math.abs(x), Math.abs(z));
        return new Vec3((double)x * offset / (double)n, 0.0, (double)z * offset / (double)n);
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        Vec3 vec3d = this.getDismountOffset(this.m_20205_() * Mth.f_13994_, passenger.m_20205_() * Mth.f_13994_);
        double ox = this.m_20185_() + vec3d.f_82479_;
        double oz = this.m_20189_() + vec3d.f_82481_;
        BlockPos exitPos = new BlockPos((int)ox, (int)this.m_20186_(), (int)oz);
        BlockPos floorPos = exitPos.m_7495_();
        if (!this.m_9236_().m_46801_(floorPos)) {
            double floorHeight;
            ArrayList list = Lists.newArrayList();
            double exitHeight = this.m_9236_().m_45573_(exitPos);
            if (DismountHelper.m_38439_((double)exitHeight)) {
                list.add(new Vec3(ox, (double)exitPos.m_123342_() + exitHeight, oz));
            }
            if (DismountHelper.m_38439_((double)(floorHeight = this.m_9236_().m_45573_(floorPos)))) {
                list.add(new Vec3(ox, (double)floorPos.m_123342_() + floorHeight, oz));
            }
            for (Pose entityPose : passenger.m_7431_()) {
                for (Vec3 vec3d2 : list) {
                    if (!DismountHelper.m_150279_((CollisionGetter)this.m_9236_(), (Vec3)vec3d2, (LivingEntity)passenger, (Pose)entityPose)) continue;
                    passenger.m_20124_(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.m_7688_(passenger);
    }

    public void copyEntityData(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float g = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += g - f;
        entity.m_146922_(entity.m_146908_() + g - f);
        entity.m_5616_(entity.m_146908_());
    }

    public void m_7340_(@NotNull Entity passenger) {
        this.copyEntityData(passenger);
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        tag.m_128350_("VehicleHealth", this.getHealth());
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
        if (tag.m_128441_("VehicleHealth")) {
            this.setHealth(tag.m_128457_("VehicleHealth"));
        }
    }

    protected void addItemTag(@NotNull CompoundTag tag) {
        CompoundTag displayTag = new CompoundTag();
        tag.m_128365_("display", (Tag)displayTag);
        if (this.m_8077_()) {
            displayTag.m_128359_("Name", Component.Serializer.m_130703_((Component)this.m_7770_()));
        }
    }

    protected void readItemTag(@NotNull CompoundTag tag) {
        CompoundTag displayTag = tag.m_128469_("display");
        if (displayTag.m_128425_("Name", 8)) {
            this.m_6593_((Component)Component.Serializer.m_130701_((String)displayTag.m_128461_("Name")));
        }
    }

    public boolean m_20068_() {
        return true;
    }

    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.getHealth() < 1.0f && (player.m_6144_() || !Config.getInstance().requireShiftForRepair) && !this.m_20363_((Entity)player)) {
            if (!this.m_9236_().f_46443_) {
                player.m_36399_(Config.getInstance().repairExhaustion);
                this.repair(Config.getInstance().repairSpeed);
                MutableComponent component = Component.m_237110_((String)"immersive_aircraft.repair", (Object[])new Object[]{(int)(this.getHealth() * 100.0f)});
                if ((double)this.getHealth() < 0.33) {
                    component.m_130940_(ChatFormatting.RED);
                } else if ((double)this.getHealth() < 0.66) {
                    component.m_130940_(ChatFormatting.GOLD);
                } else {
                    component.m_130940_(ChatFormatting.GREEN);
                }
                player.m_5661_((Component)component, true);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), Sounds.REPAIR.get(), SoundSource.NEUTRAL, 1.0f, 0.7f + this.f_19796_.m_188501_() * 0.2f);
            } else {
                for (AABB shape : this.getAdditionalShapes()) {
                    for (int i = 0; i < 5; ++i) {
                        Vec3 center = shape.m_82399_();
                        double x = center.f_82479_ + shape.m_82362_() * (this.f_19796_.m_188500_() - 0.5) * 1.5;
                        double y = center.f_82480_ + shape.m_82376_() * (this.f_19796_.m_188500_() - 0.5) * 1.5;
                        double z = center.f_82481_ + shape.m_82385_() * (this.f_19796_.m_188500_() - 0.5) * 1.5;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123749_, x, y, z, 0.0, this.f_19796_.m_188500_(), 0.0);
                    }
                }
            }
            return InteractionResult.CONSUME;
        }
        if (!this.isValidDimension()) {
            player.m_5661_((Component)Component.m_237115_((String)"immersive_aircraft.invalid_dimension"), true);
            return InteractionResult.FAIL;
        }
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_20363_((Entity)player)) {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6478_(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        Vec3 prediction = this.m_20182_().m_82549_(movement);
        super.m_6478_(movementType, movement);
        if ((this.f_19863_ || this.f_19862_) && this.m_9236_().f_46443_ && Config.getInstance().collisionDamage) {
            float repeat;
            float collision;
            double maxPossibleError = movement.m_82553_();
            double error = prediction.m_82554_(this.m_20182_());
            if (error <= maxPossibleError && (collision = (float)(error - (this.f_19863_ ? (double)Math.abs(this.getGravity()) : 0.0)) - 0.05f) > 0.0f && (repeat = 1.0f - (float)(this.getDamageWobbleTicks() + 1) / 10.0f) > 1.0E-4f) {
                float damage = collision * Config.getInstance().collisionDamageMultiplier * repeat * repeat;
                NetworkHandler.sendToServer(new CollisionMessage(damage));
            }
        }
    }

    protected void m_7840_(double heightDifference, boolean onGround, @NotNull BlockState landedState, @NotNull BlockPos landedPosition) {
    }

    public void setDamageWobbleStrength(float wobbleStrength) {
        this.f_19804_.m_135381_(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(wobbleStrength));
    }

    public float getDamageWobbleStrength() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE_WOBBLE_STRENGTH)).floatValue();
    }

    public void setDamageWobbleTicks(int wobbleTicks) {
        this.f_19804_.m_135381_(DAMAGE_WOBBLE_TICKS, (Object)wobbleTicks);
    }

    public int getDamageWobbleTicks() {
        return (Integer)this.f_19804_.m_135370_(DAMAGE_WOBBLE_TICKS);
    }

    public void setDamageWobbleSide(int side) {
        this.f_19804_.m_135381_(DAMAGE_WOBBLE_SIDE, (Object)side);
    }

    public int getDamageWobbleSide() {
        return (Integer)this.f_19804_.m_135370_(DAMAGE_WOBBLE_SIDE);
    }

    public float getHealth() {
        return ((Float)this.f_19804_.m_135370_(DATA_HEALTH)).floatValue();
    }

    public void setHealth(float damage) {
        this.f_19804_.m_135381_(DATA_HEALTH, (Object)Float.valueOf(damage));
    }

    protected boolean m_7310_(@NotNull Entity passenger) {
        return this.m_20197_().size() < this.getPassengerSpace() && !this.m_204029_(FluidTags.f_13131_);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            return le;
        }
        return super.m_6688_();
    }

    @Nullable
    public Entity getGunner(int offset) {
        List passengers = this.m_20197_();
        return passengers.isEmpty() ? null : (Entity)passengers.get(Math.max(0, passengers.size() - 1 - offset));
    }

    public void setInputs(float x, float y, float z) {
        this.movementX = x;
        this.movementY = y;
        this.movementZ = z;
    }

    public boolean canTurnOnEngine(Entity pilot) {
        return pilot instanceof Player;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.asItem());
    }

    public boolean isWithinParticleRange() {
        return Main.cameraGetter.getPosition().m_82557_(this.m_20182_()) < 1024.0;
    }

    protected Vector4f transformPosition(Matrix4f transform, float x, float y, float z) {
        return transform.transform(new Vector4f(x, y, z, 1.0f));
    }

    protected Vector3f transformVector(float x, float y, float z) {
        return this.transformVector(this.getVehicleNormalTransform(), x, y, z);
    }

    protected Vector3f transformVectorQuantized(float x, float y, float z) {
        return this.transformVector(this.getVehicleNormalTransformQuantized(), x, y, z);
    }

    protected Vector3f transformVector(Matrix3f transform, float x, float y, float z) {
        return transform.transform(new Vector3f(x, y, z));
    }

    public Matrix4f getVehicleTransform() {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)this.m_20185_(), (float)this.m_20186_(), (float)this.m_20189_());
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-this.m_146908_()));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_(this.m_146909_()));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(this.getRoll()));
        return transform;
    }

    private float quantize(float value) {
        int floor = Mth.m_14143_((float)(value * 256.0f / 360.0f));
        return (float)(floor * 360) / 256.0f;
    }

    public Matrix3f getVehicleNormalTransformQuantized() {
        Matrix3f transform = new Matrix3f();
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-this.quantize(this.m_146908_())));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_(this.quantize(this.m_146909_())));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(this.quantize(this.getRoll())));
        return transform;
    }

    public Matrix3f getVehicleNormalTransform() {
        Matrix3f transform = new Matrix3f();
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-this.m_146908_()));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_(this.m_146909_()));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(this.getRoll()));
        return transform;
    }

    public Vector3f getForwardDirection() {
        return this.transformVector(0.0f, 0.0f, 1.0f);
    }

    public Vector3f getRightDirection() {
        Vector3f f = this.transformVector(1.0f, 0.0f, 0.0f);
        return new Vector3f(f.x(), f.y(), f.z());
    }

    public Vector3f getTopDirection() {
        return this.transformVector(0.0f, 1.0f, 0.0f);
    }

    public boolean m_6783_(double distance) {
        double d = (double)Config.getInstance().renderDistance * VehicleEntity.m_20150_();
        return distance < d * d;
    }

    public void chill() {
    }

    public Vec3 toVec3d(Vector3f v) {
        return new Vec3((double)v.x, (double)v.y, (double)v.z);
    }

    public boolean isValidDimension() {
        return Config.getInstance().validDimensions.getOrDefault(this.m_9236_().m_46472_().m_135782_().toString(), true);
    }

    protected AABB getOffsetBoundingBox(BoundingBoxDescriptor descriptor) {
        Vector3f center = this.transformVectorQuantized(descriptor.x(), descriptor.y(), descriptor.z());
        return new AABB((double)center.x() - (double)descriptor.width() / 2.0 + this.m_20185_(), (double)center.y() - (double)descriptor.height() / 2.0 + this.m_20186_(), (double)center.z() - (double)descriptor.width() / 2.0 + this.m_20189_(), (double)center.x() + (double)descriptor.width() / 2.0 + this.m_20185_(), (double)center.y() + (double)descriptor.height() / 2.0 + this.m_20186_(), (double)center.z() + (double)descriptor.width() / 2.0 + this.m_20189_());
    }

    public List<AABB> getAdditionalShapes() {
        return VehicleDataLoader.get(this.identifier).getBoundingBoxes().stream().map(this::getOffsetBoundingBox).toList();
    }

    public List<AABB> getShapes() {
        ArrayList<AABB> shapes = new ArrayList<AABB>(this.getAdditionalShapes());
        shapes.add(this.m_20191_());
        return shapes;
    }

    public Vec3 getSpeedVector() {
        return new Vec3((this.lastX - this.secondLastX) / 10.0, (this.lastY - this.secondLastY) / 10.0, (this.lastZ - this.secondLastZ) / 10.0);
    }

    public boolean isPilotCreative() {
        Player player;
        LivingEntity livingEntity = this.m_6688_();
        return livingEntity instanceof Player && (player = (Player)livingEntity).m_7500_();
    }

    public double getZoom() {
        return 0.0;
    }

    public AABB m_6921_() {
        AABB box = super.m_6921_();
        for (AABB additionalShape : this.getAdditionalShapes()) {
            box = box.m_82367_(additionalShape);
        }
        return box;
    }

    public void setAnimationVariables(float tickDelta) {
        BBAnimationVariables.set("pressing_interpolated_x", this.pressingInterpolatedX.getSmooth(tickDelta));
        BBAnimationVariables.set("pressing_interpolated_y", this.pressingInterpolatedY.getSmooth(tickDelta));
        BBAnimationVariables.set("pressing_interpolated_z", this.pressingInterpolatedZ.getSmooth(tickDelta));
        Vec3 speed = this.getSpeedVector();
        BBAnimationVariables.set("velocity_x", (float)speed.f_82479_);
        BBAnimationVariables.set("velocity_y", (float)speed.f_82480_);
        BBAnimationVariables.set("velocity_z", (float)speed.f_82481_);
    }

    public Component m_5446_() {
        return super.m_5446_();
    }
}

