/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapon;

import immersive_aircraft.Entities;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.bullet.TinyTNT;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapon.BulletWeapon;
import immersive_aircraft.network.c2s.FireMessage;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BombBay
extends BulletWeapon {
    private static final float MAX_COOLDOWN = 1.0f;
    private float cooldown = 0.0f;

    public BombBay(VehicleEntity entity, ItemStack stack, WeaponMount mount, int slot) {
        super(entity, stack, mount, slot);
    }

    @Override
    protected float getBarrelLength() {
        return 0.25f;
    }

    @Override
    protected Vector4f getBarrelOffset() {
        return new Vector4f(0.0f, -0.8f, 0.0f, 1.0f);
    }

    public float getVelocity() {
        return 0.0f;
    }

    @Override
    protected Entity getBullet(Entity shooter, Vector4f position, Vector3f direction) {
        TinyTNT bullet = new TinyTNT(Entities.TINY_TNT.get(), shooter.m_9236_());
        bullet.m_6034_(position.x(), position.y(), position.z());
        direction.mul(this.getVelocity());
        bullet.m_20334_(direction.x(), direction.y(), direction.z());
        return bullet;
    }

    @Override
    public void tick() {
        this.cooldown -= 0.05f;
    }

    @Override
    public void fire(Vector3f direction) {
        if (this.spentAmmo(Config.getInstance().bombBayAmmunition, 20)) {
            super.fire(direction);
        }
    }

    @Override
    public void clientFire(int index) {
        if (this.cooldown <= 0.0f) {
            this.cooldown = 1.0f;
            NetworkHandler.sendToServer(new FireMessage(this.getSlot(), index, this.getDirection()));
        }
    }

    private Vector3f getDirection() {
        Vector3f direction = new Vector3f(0.0f, 1.0f, 0.0f);
        direction.mul((Matrix3fc)new Matrix3f((Matrix4fc)this.getMount().transform()));
        direction.mul((Matrix3fc)this.getEntity().getVehicleNormalTransform());
        return direction;
    }
}

