/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.item;

import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.item.DescriptionItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class VehicleItem
extends DescriptionItem {
    private final VehicleConstructor constructor;

    public VehicleItem(Item.Properties settings, VehicleConstructor constructor) {
        super(settings);
        this.constructor = constructor;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        BlockHitResult hitResult = VehicleItem.m_41435_((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            VehicleItem.error(user, "immersive_aircraft.tooltip.no_target");
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            VehicleEntity entity = this.constructor.create(world);
            entity.fromItemStack(itemStack);
            entity.m_6034_(hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_);
            entity.m_146922_(user.m_146908_());
            if (!world.m_45756_((Entity)entity, entity.m_20191_())) {
                VehicleItem.error(user, "immersive_aircraft.tooltip.no_space");
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            if (!world.f_46443_) {
                world.m_7967_((Entity)entity);
                world.m_142346_((Entity)user, GameEvent.f_157810_, BlockPos.m_274446_((Position)hitResult.m_82450_()));
                if (!user.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
            }
            user.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    private static void error(Player user, String message) {
        user.m_5661_((Component)Component.m_237115_((String)message).m_130940_(ChatFormatting.RED), true);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("Inventory")) {
            ListTag nbtList = tag.m_128437_("Inventory", 10);
            tooltip.add((Component)Component.m_237110_((String)"immersive_aircraft.tooltip.inventory", (Object[])new Object[]{nbtList.size()}));
        }
    }

    public static interface VehicleConstructor {
        public VehicleEntity create(Level var1);
    }
}

